/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCTypednameValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSETypedName
extends JCTypednameValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"dn", "level", "interval"};

    protected DSETypedName(String string) {
        this.attributeName = string;
        this.syntax = 25;
    }

    protected DSETypedName(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 25;
        this.attributeName = string;
        this.syntax = 23;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        this.setLevel(dxEventInputStream.read_uint32());
        this.setInterval(dxEventInputStream.read_uint32());
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setEntryDN(Driver.changeDNForm(string2));
    }

    public DSETypedName(JCTypednameValue jCTypednameValue) {
        super(jCTypednameValue.attributeName, jCTypednameValue.operation, jCTypednameValue.flags, jCTypednameValue.timestamp, Driver.changeDNForm(jCTypednameValue.getEntryDN()), jCTypednameValue.getLevel(), jCTypednameValue.getInterval());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"dn", "level", "interval"};
        String[] stringArray2 = new String[]{this.getEntryDN(), Integer.toString(this.getLevel()), Integer.toString(this.getInterval())};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            return stringArray[nArray[0]].equals(this.getEntryDN()) && Integer.valueOf(stringArray[nArray[1]]).intValue() == this.getLevel() && Integer.valueOf(stringArray[nArray[2]]).intValue() == this.getInterval();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            this.setEntryDN(stringArray[nArray[0]]);
            this.setLevel(Integer.valueOf(stringArray[nArray[1]]));
            this.setInterval(Integer.valueOf(stringArray[nArray[2]]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setEntryDN(DSEUtil.encrypt(this.getEntryDN(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setEntryDN(DSEUtil.decrypt(this.getEntryDN(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getEntryDN();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        n += this.getLevel();
        return n += this.getInterval();
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCTypednameValue jCTypednameValue = (JCTypednameValue)object;
        n = this.getEntryDN().compareTo(jCTypednameValue.getEntryDN());
        if (n == 0) {
            n = this.getLevel() - jCTypednameValue.getLevel();
        }
        if (n == 0) {
            n = this.getInterval() - jCTypednameValue.getInterval();
        }
        return n;
    }
}

