/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64OutputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import java.util.Arrays;
import novell.jclient.JCUnknownValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEUnknown
extends JCUnknownValue
implements DSEAttributeValue {
    protected DSEUnknown(String string) {
        this.attributeName = string;
        this.syntax = 0;
    }

    protected DSEUnknown(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 0;
        this.setData(dxEventInputStream.readOctets());
    }

    public DSEUnknown(JCUnknownValue jCUnknownValue) {
        super(jCUnknownValue.attributeName, jCUnknownValue.operation, jCUnknownValue.flags, jCUnknownValue.timestamp, jCUnknownValue.getData());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        DSEUtil.createValueElement(element, "octet", new String(Base64OutputStream.encode((byte[])this.getData())));
    }

    public boolean equals(Element element) {
        try {
            return Arrays.equals(this.getData(), DSEUtil.validateOctet(element));
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        this.setData(DSEUtil.validateOctet(element));
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setData(DSEUtil.encrypt(this.getData(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setData(DSEUtil.decrypt(this.getData(), byArray));
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getData();
        if (byArray != null) {
            n += DSEUtil.hashCode(byArray);
        }
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCUnknownValue jCUnknownValue = (JCUnknownValue)object;
        byte[] byArray = this.getData();
        byte[] byArray2 = jCUnknownValue.getData();
        return DSEUtil.compareTo(byArray, byArray2);
    }
}

