/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.RuleContextProvider;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.XPathVariable;
import com.novell.xml.dom.DOMEvaluator;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DoCloneXPath
extends Action
implements VariableBindings,
RuleContextProvider {
    protected String srcExpressionString;
    protected String destExpressionString;
    protected DOMEvaluator srcExpression;
    protected DOMEvaluator destExpression;
    protected RuleDynamicContext currentDynamicContext;

    protected DoCloneXPath(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.srcExpressionString = RuleUtil.getAttrString(element, "src-expression", null);
        this.destExpressionString = RuleUtil.getAttrString(element, "dest-expression", null);
        Element element2 = XdsUtil.getFirstAncestorElementByTagNameNS(element, null, "policy");
        try {
            this.srcExpression = new DOMEvaluator(this.srcExpressionString, (Node)element2, ruleStaticContext.loader, (VariableBindings)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VRDException(9130, this.location, this.srcExpressionString, illegalArgumentException.toString());
        }
        try {
            this.destExpression = new DOMEvaluator(this.destExpressionString, (Node)element2, ruleStaticContext.loader, (VariableBindings)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VRDException(9130, this.location, this.destExpressionString, illegalArgumentException.toString());
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.currentDynamicContext = ruleDynamicContext;
        try {
            NodeSet nodeSet = ruleDynamicContext.evaluateXPath(this.srcExpression, element).getNodeSetValue();
            NodeSet nodeSet2 = ruleDynamicContext.evaluateXPath(this.destExpression, element).getNodeSetValue();
            Node node = nodeSet2.first();
            while (node != null) {
                if (node.getNodeType() != 1) {
                    throw new VRDException(9147, this.location, (Object)this.display);
                }
                Element element2 = (Element)node;
                Node node2 = nodeSet.first();
                while (node2 != null) {
                    switch (node2.getNodeType()) {
                        case 2: {
                            element2.setAttributeNode((Attr)element2.getOwnerDocument().importNode(node2, true));
                            break;
                        }
                        case 9: {
                            Node node3 = node2.getFirstChild();
                            while (node3 != null) {
                                element2.appendChild(element2.getOwnerDocument().importNode(node3, true));
                                node3 = node3.getNextSibling();
                            }
                            break;
                        }
                        default: {
                            element2.appendChild(element2.getOwnerDocument().importNode(node2, true));
                        }
                    }
                    node2 = nodeSet.next();
                }
                DOMUtil.addNamespaceDecls((Node)element2);
                node = nodeSet2.next();
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            throw new VRDException(9131, this.location, this.display, xPathEvaluationException.toString());
        }
        catch (DOMException dOMException) {
            throw new VRDException(dOMException);
        }
        return false;
    }

    public RuleStaticContext getStaticContext() {
        return this.staticContext;
    }

    public RuleDynamicContext getDynamicContext() {
        return this.currentDynamicContext;
    }

    public Expression getVariable(ExpandedQName expandedQName) {
        if (!expandedQName.getNamespaceName().isEmpty()) {
            return null;
        }
        return new XPathVariable(expandedQName.getLocalPart(), this);
    }
}

