/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import org.w3c.dom.Element;

class DoGenerateEvent
extends Action {
    private Arg[] args = null;
    private String text1 = null;
    private String text2 = null;
    private String text3 = null;
    private String target = null;
    private String subTarget = null;
    private String data = null;
    private long mimeType = 0L;
    private int targetType = 0;
    private int value = 0;
    private int value3 = 0;
    private int eventID = 1000;
    private int level = 7;

    protected DoGenerateEvent(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.eventID = RuleUtil.getAttrInt(element, "id", 0, true, 1000, 1999);
        String string = RuleUtil.getAttrString(element, "level", "log-info");
        this.level = this.getLogLevelFromString(string);
        this.args = Arg.getArgs(element, ruleStaticContext);
        if (this.args == null || this.args.length == 0) {
            throw new VRDException(9127, this.location, (Object)"arg-value");
        }
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].getType() != 6) {
                throw new VRDException(9124, this.args[n].location, this.args[n].getTypeElementName(), element.getNodeName());
            }
            ++n;
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.text1 = null;
        this.text2 = null;
        this.text3 = null;
        this.target = null;
        this.subTarget = null;
        this.data = null;
        this.mimeType = 0L;
        this.targetType = 0;
        this.value = 0;
        this.value3 = 0;
        int n = 0;
        while (n < this.args.length) {
            String string = this.args[n].getName();
            if (string != null) {
                Integer n2;
                if (string.equalsIgnoreCase("target")) {
                    this.target = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("subtarget")) {
                    this.subTarget = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("text1")) {
                    this.text1 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("text2")) {
                    this.text2 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("text3")) {
                    this.text3 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("data")) {
                    this.data = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string.equalsIgnoreCase("value")) {
                    n2 = null;
                    try {
                        n2 = new Integer(this.args[n].evaluate(element, ruleDynamicContext).toString());
                        this.value = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.value = 0;
                    }
                } else if (string.equalsIgnoreCase("value3")) {
                    n2 = null;
                    try {
                        n2 = new Integer(this.args[n].evaluate(element, ruleDynamicContext).toString());
                        this.value3 = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.value3 = 0;
                    }
                } else if (string.equalsIgnoreCase("target-type")) {
                    n2 = null;
                    try {
                        n2 = new Integer(this.args[n].evaluate(element, ruleDynamicContext).toString());
                        this.targetType = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.targetType = 0;
                    }
                } else if (string.equalsIgnoreCase("data-type")) {
                    n2 = null;
                    try {
                        n2 = new Integer(this.args[n].evaluate(element, ruleDynamicContext).toString());
                        this.mimeType = n2.intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.mimeType = 0L;
                    }
                }
            }
            ++n;
        }
        if (this.staticContext.altPersistentLog != null) {
            this.staticContext.altPersistentLog.logEvent(this.staticContext, ruleDynamicContext, this.eventID, this.level, this.target, this.targetType, this.subTarget, this.text1, this.text2, this.text3, this.value, this.value3, this.mimeType, this.data);
        } else if (!DirXML.isExternal()) {
            PersistentLog.logUserEvent(this.eventID, this.level, this.target, this.targetType, this.subTarget, this.text1, this.text2, this.text3, this.value, this.value3, this.mimeType, this.data);
        } else {
            this.staticContext.tracer.trace("rct_user_event", (MessageSource)RuleConstants.messageSource);
        }
        return false;
    }

    int getLogLevelFromString(String string) {
        if (string == null) {
            return 7;
        }
        if (string.equalsIgnoreCase("log-emergency")) {
            return 1;
        }
        if (string.equalsIgnoreCase("log-alert")) {
            return 2;
        }
        if (string.equalsIgnoreCase("log-critical")) {
            return 3;
        }
        if (string.equalsIgnoreCase("log-error")) {
            return 4;
        }
        if (string.equalsIgnoreCase("log-warning")) {
            return 5;
        }
        if (string.equalsIgnoreCase("log-notice")) {
            return 6;
        }
        if (string.equalsIgnoreCase("log-info")) {
            return 7;
        }
        if (string.equalsIgnoreCase("log-debug")) {
            return 8;
        }
        return 7;
    }
}

