/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.mail.SMTPPassword;
import com.novell.nds.dirxml.util.mail.SendMail;
import org.w3c.dom.Element;

class DoSendEmail
extends Action {
    private Arg[] args = null;
    private String server = null;
    private String id = null;
    private String pwd = null;
    private boolean doHtml = false;
    static String toMsg = RuleConstants.messageSource.getMessageString("rct_noemailto");
    static String srvrMsg = RuleConstants.messageSource.getMessageString("rct_nosmtpsrvr");

    protected DoSendEmail(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.server = RuleUtil.getAttrString(element, "server", null);
        this.id = RuleUtil.getAttrString(element, "id", "");
        this.pwd = RuleUtil.getAttrString(element, "password", "");
        String string = RuleUtil.getAttrString(element, "type", "text");
        this.pwd = this.pwd.length() == 0 ? null : SMTPPassword.decode((String)this.pwd);
        this.doHtml = false;
        if (string.equalsIgnoreCase("html")) {
            this.doHtml = true;
        }
        this.args = Arg.getArgs(element, ruleStaticContext);
        if (this.args == null || this.args.length == 0) {
            throw new VRDException(9127, this.location, (Object)"arg-value");
        }
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].getType() != 6) {
                throw new VRDException(9124, this.args[n].location, this.args[n].getTypeElementName(), element.getNodeName());
            }
            ++n;
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        String string6 = null;
        SendMail.EmailAddress[] emailAddressArray = new SendMail.EmailAddress[this.args.length];
        int n = 0;
        int n2 = 0;
        while (n < this.args.length) {
            String string7 = this.args[n].getName();
            if (string7 != null) {
                String string8;
                if (string7.equalsIgnoreCase("to")) {
                    string8 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                    if (string8 != null && string8.length() != 0) {
                        string = string8;
                        emailAddressArray[n2++] = new SendMail.EmailAddress(string, 0);
                    }
                } else if (string7.equalsIgnoreCase("cc")) {
                    string8 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                    if (string8 != null && string8.length() != 0) {
                        emailAddressArray[n2++] = new SendMail.EmailAddress(string8, 1);
                    }
                } else if (string7.equalsIgnoreCase("bcc")) {
                    string8 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                    if (string8 != null && string8.length() != 0) {
                        emailAddressArray[n2++] = new SendMail.EmailAddress(string8, 2);
                    }
                } else if (string7.equalsIgnoreCase("from")) {
                    string2 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string7.equalsIgnoreCase("reply-to")) {
                    string3 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string7.equalsIgnoreCase("subject")) {
                    string4 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string7.equalsIgnoreCase("message")) {
                    string5 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                } else if (string7.equalsIgnoreCase("encoding")) {
                    string6 = this.args[n].evaluate(element, ruleDynamicContext).toString();
                }
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            if (!DirXML.isExternal()) {
                PersistentLog.logEvent(39, 5, null, 0L, "DoSendEmail", toMsg, null, null, 0L, 0L);
            }
            if (this.staticContext.tracer.getLevel() >= 3) {
                this.staticContext.tracer.trace("rct_noemailto", (MessageSource)RuleConstants.messageSource);
            }
            return false;
        }
        if (this.server == null || this.server.length() == 0) {
            if (!DirXML.isExternal()) {
                PersistentLog.logEvent(39, 5, null, 0L, "DoSendEmail", srvrMsg, null, null, 0L, 0L);
            }
            if (this.staticContext.tracer.getLevel() >= 3) {
                this.staticContext.tracer.trace("rct_nosmtpsrvr", (MessageSource)RuleConstants.messageSource);
            }
            return false;
        }
        SendMail.generateEMail((String)this.server, string2, string3, (SendMail.EmailAddress[])emailAddressArray, (String)string4, (String)string5, (String)this.id, (String)this.pwd, string6, (boolean)this.doHtml);
        return false;
    }
}

