/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DoSetDefaultAttrValue
extends Action {
    private String name;
    private boolean writeBack;
    private Arg[] args;

    protected DoSetDefaultAttrValue(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.name = RuleUtil.getAttrString(element, "name", null);
        this.writeBack = RuleUtil.getAttrBoolean(element, "write-back", false);
        this.args = Arg.getArgs(element, ruleStaticContext);
        if (this.args == null || this.args.length == 0) {
            throw new VRDException(9127, this.location, (Object)"arg-value");
        }
        int n = 0;
        while (n < this.args.length) {
            switch (this.args[n].getType()) {
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    throw new VRDException(9124, this.args[n].location, this.args[n].getTypeElementName(), element.getNodeName());
                }
            }
            ++n;
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        if (element.getNamespaceURI() != null || !element.getLocalName().equals("add")) {
            throw new VRDException(9146, this.location, "do-set-default-attr-value", element.getNodeName());
        }
        if (RuleUtil.getValues(element, this.name, 5) == null) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElementNS(null, "add-attr");
            element2.setAttributeNS(null, "attr-name", this.name);
            Element[] elementArray = new Element[this.args.length];
            int n = 0;
            while (n < this.args.length) {
                elementArray[n] = (Element)this.args[n].evaluate(element, ruleDynamicContext);
                element2.appendChild(elementArray[n]);
                ++n;
            }
            RuleUtil.addAttr(element, element2);
            if (this.writeBack) {
                String string;
                String string2 = element.getAttributeNS(null, "src-dn");
                String string3 = XdsUtil.getAssociationValue(element);
                Element element3 = RuleUtil.findOrCreateModOperation(element, string3, string2, string = element.getAttributeNS(null, "class-name"), 4);
                if (element3 == null) {
                    throw new VRDException(9145, this.location, (Object)this.display);
                }
                XdsUtil.copyAttributeNS(element, null, "src-dn", element3);
                XdsUtil.copyAttributeNS(element, null, "src-entry-id", element3);
                XdsUtil.copyAttributeNS(element, null, "src-entry-id", element3, null, "dest-entry-id");
                Element element4 = document.createElementNS(null, "modify-attr");
                element3.appendChild(element4);
                element4.setAttributeNS(null, "attr-name", this.name);
                Element element5 = document.createElementNS(null, "add-value");
                element4.appendChild(element5);
                int n2 = 0;
                while (n2 < this.args.length) {
                    element5.appendChild(elementArray[n2].cloneNode(true));
                    ++n2;
                }
            }
        }
        return false;
    }
}

