/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleContextProvider;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.XPathVariable;
import com.novell.xml.dom.DOMEvaluator;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DoSetXMLAttr
extends Action
implements VariableBindings,
RuleContextProvider {
    protected String expressionString;
    protected String name;
    protected String namespaceURI = null;
    protected DOMEvaluator expression;
    protected RuleDynamicContext currentDynamicContext;
    protected Arg argString = null;

    protected DoSetXMLAttr(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.expressionString = RuleUtil.getAttrString(element, "expression", null);
        this.name = RuleUtil.getAttrString(element, "name", null);
        Element element2 = XdsUtil.getFirstAncestorElementByTagNameNS(element, null, "policy");
        int n = this.name.indexOf(58);
        if (n != -1) {
            this.namespaceURI = RuleUtil.getNamespaceDecl(element2, this.name.substring(0, n));
        }
        try {
            this.expression = new DOMEvaluator(this.expressionString, (Node)element2, ruleStaticContext.loader, (VariableBindings)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VRDException(9130, this.location, this.expressionString, illegalArgumentException.toString());
        }
        Arg[] argArray = Arg.getArgs(element, ruleStaticContext);
        if (argArray == null || argArray.length == 0) {
            throw new VRDException(9127, this.location, (Object)"arg-string");
        }
        int n2 = 0;
        while (n2 < argArray.length) {
            if (n2 > 0) {
                throw new VRDException(9124, argArray[n2].location, argArray[n2].getTypeElementName(), element.getNodeName());
            }
            switch (argArray[n2].getType()) {
                case 6: {
                    this.argString = argArray[n2];
                    break;
                }
                default: {
                    throw new VRDException(9124, argArray[n2].location, argArray[n2].getTypeElementName(), element.getNodeName());
                }
            }
            ++n2;
        }
        if (this.argString == null) {
            throw new VRDException(9127, this.location, (Object)"arg-string");
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.currentDynamicContext = ruleDynamicContext;
        String string = this.argString.evaluate(element, ruleDynamicContext).toString();
        try {
            NodeSet nodeSet = ruleDynamicContext.evaluateXPath(this.expression, element).getNodeSetValue();
            Node node = nodeSet.first();
            while (node != null) {
                if (node.getNodeType() != 1) {
                    throw new VRDException(9147, this.location, (Object)this.display);
                }
                ((Element)node).setAttributeNS(this.namespaceURI, this.name, string);
                DOMUtil.addNamespaceDecls((Node)node);
                node = nodeSet.next();
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            throw new VRDException(9131, this.location, this.display, xPathEvaluationException.toString());
        }
        catch (DOMException dOMException) {
            throw new VRDException(dOMException);
        }
        return false;
    }

    public RuleStaticContext getStaticContext() {
        return this.staticContext;
    }

    public RuleDynamicContext getDynamicContext() {
        return this.currentDynamicContext;
    }

    public Expression getVariable(ExpandedQName expandedQName) {
        if (!expandedQName.getNamespaceName().isEmpty()) {
            return null;
        }
        return new XPathVariable(expandedQName.getLocalPart(), this);
    }
}

