/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StringUtil;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import novell.jclient.JCClassDef;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Filter
implements RuleConstants {
    public static final int SUB = 0;
    public static final int PUB = 1;
    public static final int SYNC_SYNC = 0;
    public static final int SYNC_RESET = 1;
    public static final int SYNC_NOTIFY = 2;
    public static final int SYNC_IGNORE = 3;
    private static final String[] CLASS_SYNC_MODE_TABLE = new String[]{"sync", "sync", "sync", "ignore"};
    private static final String[] ATTR_SYNC_MODE_TABLE = new String[]{"sync", "reset", "notify", "ignore"};
    public static final int MERGE_DEFAULT = 0;
    public static final int MERGE_EDIR = 1;
    public static final int MERGE_APP = 2;
    public static final int MERGE_NONE = 4;
    private static final String[] MERGE_AUTH_TABLE = new String[]{"default", "edir", "app", "none"};
    private TreeMap classes = new TreeMap(StringUtil.getCaseIgnoreComparator());
    private EngineTrace tracer;

    public Filter(Node node, EngineTrace engineTrace) throws VRDException {
        this.tracer = engineTrace;
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
            }
            case 1: {
                if (element != null && element.getLocalName().equals("filter") && element.getNamespaceURI() == null) break;
            }
            default: {
                throw new VRDException(9123, RuleUtil.getNodeLocation(node), (Object)"filter");
            }
        }
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                new ClassEntry((Element)node2, this.classes);
            }
            node2 = node2.getNextSibling();
        }
    }

    public ClassEntry getClassEntry(String string) {
        return (ClassEntry)this.classes.get(string);
    }

    public AttrEntry getAttrEntry(String string, String string2) {
        ClassEntry classEntry = this.getClassEntry(string);
        if (classEntry == null) {
            return null;
        }
        return classEntry.getAttrEntry(string2);
    }

    public int checkAttrFilter(String string, String string2, int n) {
        ClassEntry classEntry = this.getClassEntry(string);
        if (classEntry == null || classEntry.getSyncMode(n) == 3) {
            return 3;
        }
        AttrEntry attrEntry = classEntry.getAttrEntry(string2);
        if (attrEntry == null) {
            return 3;
        }
        return attrEntry.getSyncMode(n);
    }

    public int checkClassFilter(String string, int n) {
        ClassEntry classEntry = (ClassEntry)this.classes.get(string);
        if (classEntry == null) {
            return 3;
        }
        return classEntry.getSyncMode(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document filterDocument(Document document, int n, int n2, boolean bl) {
        this.tracer.pushIndent(1);
        try {
            Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(document, "*", "*", null, "class-name");
            int n3 = 0;
            while (n3 < elementArray.length) {
                Element element = elementArray[n3];
                String string = element.getAttributeNS(null, "class-name");
                String string2 = element.getNodeName();
                if (bl || !string2.equals("query") && !string2.equals("instance") && element.getParentNode().getNodeName().equals("input")) {
                    ClassEntry classEntry = this.getClassEntry(string);
                    if (classEntry != null && classEntry.getSyncMode(n) == 0) {
                        Element[] elementArray2 = XdsUtil.getElementsByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
                        int n4 = elementArray2.length;
                        if (n4 != 0) {
                            int n5 = 0;
                            while (n5 < elementArray2.length) {
                                Element element2 = elementArray2[n5];
                                String string3 = element2.getAttributeNS(null, "attr-name");
                                AttrEntry attrEntry = classEntry.getAttrEntry(string3);
                                if (attrEntry == null || attrEntry.getSyncMode(n) > n2 || bl && !attrEntry.isMergeSource(n)) {
                                    if (!bl && this.tracer.getLevel() > 0) {
                                        this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, element2.getNodeName(), (Object)"attr-name", (Object)string3);
                                    }
                                    element2.getParentNode().removeChild(element2);
                                    --n4;
                                }
                                ++n5;
                            }
                            if (n4 == 0 && string2.equals("modify")) {
                                if (!bl && this.tracer.getLevel() > 0) {
                                    this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, string2, (Object)"class-name", (Object)string);
                                }
                                element.getParentNode().removeChild(element);
                            }
                        }
                    } else {
                        if (!bl && this.tracer.getLevel() > 0) {
                            this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, string2, (Object)"class-name", (Object)string);
                        }
                        element.getParentNode().removeChild(element);
                    }
                }
                ++n3;
            }
            Object var18_17 = null;
            this.tracer.popIndent();
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            this.tracer.popIndent();
            throw throwable;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document filterNotifyAttrs(Document document, int n, List list) {
        this.tracer.pushIndent(1);
        try {
            Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(document, "*", "*", null, "class-name");
            int n2 = 0;
            while (n2 < elementArray.length) {
                Element element = elementArray[n2];
                String string = element.getAttributeNS(null, "class-name");
                String string2 = element.getNodeName();
                if (!(string2.equals("query") || string2.equals("instance") || !element.getParentNode().getNodeName().equals("input") || string2.equals("modify") && element.getAttributeNS(null, "from-merge").equals("true"))) {
                    ClassEntry classEntry = this.getClassEntry(string);
                    if (classEntry != null && classEntry.hasNotifyAttrs[n]) {
                        Element[] elementArray2 = XdsUtil.getElementsByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
                        int n3 = elementArray2.length;
                        if (n3 != 0) {
                            int n4 = 0;
                            while (n4 < elementArray2.length) {
                                Element element2 = elementArray2[n4];
                                String string3 = element2.getAttributeNS(null, "attr-name");
                                AttrEntry attrEntry = classEntry.getAttrEntry(string3);
                                if (attrEntry != null && (attrEntry.getSyncMode(n) == 2 || attrEntry.getSyncMode(n) == 1)) {
                                    if (this.tracer.getLevel() > 0) {
                                        this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, element2.getNodeName(), (Object)"attr-name", (Object)string3);
                                    }
                                    if (attrEntry.getSyncMode(n) == 1 && list != null) {
                                        ResetItem.addResetItem(list, string3, element, n);
                                    }
                                    element2.getParentNode().removeChild(element2);
                                    --n3;
                                }
                                ++n4;
                            }
                            if (n3 == 0 && string2.equals("modify")) {
                                if (this.tracer.getLevel() > 0) {
                                    this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, string2, (Object)"class-name", (Object)string);
                                }
                                element.getParentNode().removeChild(element);
                            }
                        } else if (string2.equals("modify")) {
                            if (this.tracer.getLevel() > 0) {
                                this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, string2, (Object)"class-name", (Object)string);
                            }
                            element.getParentNode().removeChild(element);
                        }
                    } else if (string2.equals("modify") && XdsUtil.getFirstChildElementByTagNameNS(element, null, "modify-attr") == null) {
                        if (this.tracer.getLevel() > 0) {
                            this.tracer.trace("rct_fltrdout", (MessageSource)RuleConstants.messageSource, string2, (Object)"class-name", (Object)string);
                        }
                        element.getParentNode().removeChild(element);
                    }
                }
                ++n2;
            }
            Object var17_16 = null;
            this.tracer.popIndent();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            this.tracer.popIndent();
            throw throwable;
        }
        return document;
    }

    public void toV1FilterXML(Element element, int n) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "driver-filter");
        element.appendChild(element2);
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassEntry classEntry = (ClassEntry)iterator.next();
            if (classEntry.getSyncMode(n) == 3) continue;
            Element element3 = document.createElementNS(null, "allow-class");
            element2.appendChild(element3);
            element3.setAttributeNS(null, "class-name", classEntry.className);
            Iterator iterator2 = classEntry.attrs.values().iterator();
            while (iterator2.hasNext()) {
                AttrEntry attrEntry = (AttrEntry)iterator2.next();
                if (attrEntry.getSyncMode(n) == 3 || n == 0 && (attrEntry.getSyncMode(n) == 2 || attrEntry.getSyncMode(n) == 1)) continue;
                Element element4 = document.createElementNS(null, "allow-attr");
                element3.appendChild(element4);
                element4.setAttributeNS(null, "attr-name", attrEntry.attrName);
            }
        }
    }

    public String[] getClassAttrs(String string, int n, int n2, boolean bl) {
        ClassEntry classEntry = this.getClassEntry(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (classEntry != null && classEntry.getSyncMode(n) != 3) {
            Iterator iterator = classEntry.attrs.values().iterator();
            while (iterator.hasNext()) {
                AttrEntry attrEntry = (AttrEntry)iterator.next();
                if (attrEntry.getSyncMode(n) > n2 || bl && !attrEntry.isMergeSource(n)) continue;
                arrayList.add(attrEntry.getName());
            }
        }
        if (arrayList.size() == 0) {
            return new String[]{""};
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filterByDriverRights(JCContext jCContext, String string, Node node) throws VRDException {
        JCContext jCContext2 = null;
        try {
            try {
                jCContext2 = jCContext.duplicate();
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    Entry entry;
                    Element element;
                    Node node3 = node2;
                    node2 = node2.getNextSibling();
                    if (!(node3 instanceof Element) || (element = (Element)node3).getNodeName().equals("delete") || (entry = XdsUtil.getSrcEntry(element)) == null) continue;
                    try {
                        entry.goTo(jCContext2);
                        long l = jCContext2.getEffectivePrivileges(string, "[Entry Rights]");
                        if ((l & 0x10L) != 0L) continue;
                        if ((l & 1L) == 0L) {
                            if (this.tracer.getLevel() > 0) {
                                this.tracer.trace("rct_nodrt", (MessageSource)RuleConstants.messageSource, entry.getDN());
                            }
                            node.removeChild(element);
                            continue;
                        }
                        Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
                        boolean bl = false;
                        int n = 0;
                        while (n < elementArray.length) {
                            String string2 = elementArray[n].getAttributeNS(null, "attr-name");
                            if (!StringUtil.startsWithIgnoreCase(string2, "[Entry].")) {
                                long l2 = jCContext2.getEffectivePrivileges(string, string2);
                                if ((l2 & 2L) == 0L) {
                                    if (this.tracer.getLevel() > 0) {
                                        this.tracer.trace("rct_nodrt", (MessageSource)RuleConstants.messageSource, entry.getDN() + '#' + string2);
                                    }
                                    elementArray[n].getParentNode().removeChild(elementArray[n]);
                                } else {
                                    bl = true;
                                }
                            }
                            ++n;
                        }
                        if (bl || !element.getNodeName().equals("modify")) continue;
                        node.removeChild(element);
                    }
                    catch (JCException jCException) {
                        VRDException vRDException = new VRDException(jCException);
                        if (vRDException.isRetry()) {
                            throw vRDException;
                        }
                        node.removeChild(element);
                    }
                }
            }
            catch (JCException jCException) {
                throw new VRDException(jCException);
            }
            Object var18_18 = null;
            if (jCContext2 == null) return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
    }

    public static class ResetItem {
        private ArrayList attrNames = new ArrayList();
        private String className;
        private String opName;
        private String association;
        private Entry entry;

        private static void addResetItem(List list, String string, Element element, int n) {
            Entry entry;
            String string2 = element.getAttributeNS(null, "class-name");
            String string3 = element.getNodeName();
            String string4 = XdsUtil.getAssociationValue(element);
            if (string4 == null || string4.length() == 0) {
                return;
            }
            try {
                entry = n == 0 ? XdsUtil.getSrcEntry(element) : XdsUtil.getDestEntry(element);
            }
            catch (VRDException vRDException) {
                entry = null;
            }
            if (entry == null) {
                return;
            }
            if (!string3.equals("add") && !string3.equals("modify")) {
                return;
            }
            ResetItem resetItem = null;
            int n2 = 0;
            while (n2 < list.size()) {
                ResetItem resetItem2 = (ResetItem)list.get(n2);
                if (resetItem2.association.equals(string4)) {
                    resetItem = resetItem2;
                }
                ++n2;
            }
            if (resetItem == null) {
                resetItem = new ResetItem(element.getAttributeNS(null, "class-name"), string3, string4, entry);
                list.add(resetItem);
                resetItem.attrNames.add(string);
            } else {
                if (!resetItem.attrNames.contains(string)) {
                    resetItem.attrNames.add(string);
                }
                if (string3.equals("add")) {
                    resetItem.opName = element.getNodeName();
                }
            }
        }

        private ResetItem(String string, String string2, String string3, Entry entry) {
            this.className = string;
            this.opName = string2;
            this.association = string3;
            this.entry = entry;
        }

        public String[] getAttrNames() {
            return this.attrNames.toArray(new String[this.attrNames.size()]);
        }

        public String getClassName() {
            return this.className;
        }

        public String getOpName() {
            return this.opName;
        }

        public String getAssociation() {
            return this.association;
        }

        public Entry getEntry() {
            return this.entry;
        }
    }

    public static class AttrEntry {
        private String attrName;
        private int[] syncMode = new int[2];
        private int mergeAuthority;
        private boolean[] mergeSource = new boolean[2];
        private boolean pubOptimizeModify;

        private AttrEntry(Element element, TreeMap treeMap) throws VRDException {
            if (!element.getLocalName().equals("filter-attr") || element.getNamespaceURI() != null) {
                throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), "filter-attr");
            }
            this.attrName = RuleUtil.getAttrString(element, "attr-name", null);
            if (treeMap.put(this.attrName, this) != null) {
                throw new VRDException(9019, RuleUtil.getNodeLocation(element), element.getNodeName(), this.attrName);
            }
            this.syncMode[0] = RuleUtil.getAttrIndex(element, "subscriber", 3, ATTR_SYNC_MODE_TABLE);
            this.syncMode[1] = RuleUtil.getAttrIndex(element, "publisher", 3, ATTR_SYNC_MODE_TABLE);
            this.mergeAuthority = RuleUtil.getAttrIndex(element, "merge-authority", 0, MERGE_AUTH_TABLE);
            this.pubOptimizeModify = RuleUtil.getAttrBoolean(element, "publisher-optimize-modify", true);
            this.mergeSource[0] = this.syncMode[0] == 0 && (this.mergeAuthority == 0 || this.mergeAuthority == 1);
            boolean bl = this.mergeSource[1] = this.syncMode[1] == 0 && (this.mergeAuthority == 0 || this.mergeAuthority == 2);
            if (this.syncMode[0] == 1 && this.syncMode[1] == 1) {
                throw new VRDException(9026, RuleUtil.getNodeLocation(element), element.getNodeName(), this.attrName);
            }
        }

        public String getName() {
            return this.attrName;
        }

        public int getSyncMode(int n) {
            return this.syncMode[n];
        }

        public int getMergeAuthority() {
            return this.mergeAuthority;
        }

        public boolean isMergeSource(int n) {
            return this.mergeSource[n];
        }

        public boolean getOptimizeModify(int n) {
            if (n == 1) {
                return this.pubOptimizeModify && this.syncMode[n] != 2;
            }
            return this.syncMode[n] != 2;
        }
    }

    public static class ClassEntry {
        private TreeMap attrs = new TreeMap(StringUtil.getCaseIgnoreComparator());
        private int[] syncMode = new int[2];
        private boolean pubCreateHomeDir;
        private boolean pubTrackTemplate;
        private String className;
        private boolean[] hasNotifyAttrs = new boolean[]{false, false};

        private ClassEntry(Element element, TreeMap treeMap) throws VRDException {
            if (!element.getLocalName().equals("filter-class") || element.getNamespaceURI() != null) {
                throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), "filter-class");
            }
            this.className = RuleUtil.getAttrString(element, "class-name", null);
            if (treeMap.put(this.className, this) != null) {
                throw new VRDException(9019, RuleUtil.getNodeLocation(element), element.getNodeName(), this.className);
            }
            this.syncMode[0] = RuleUtil.getAttrIndex(element, "subscriber", 3, CLASS_SYNC_MODE_TABLE);
            this.syncMode[1] = RuleUtil.getAttrIndex(element, "publisher", 3, CLASS_SYNC_MODE_TABLE);
            this.pubCreateHomeDir = RuleUtil.getAttrBoolean(element, "publisher-create-homedir", true);
            this.pubTrackTemplate = RuleUtil.getAttrBoolean(element, "publisher-track-template-member", false);
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    String[] stringArray;
                    JCClassDef jCClassDef;
                    AttrEntry attrEntry = new AttrEntry((Element)node, this.attrs);
                    this.hasNotifyAttrs[0] = this.hasNotifyAttrs[0] | attrEntry.getSyncMode(0) == 2;
                    this.hasNotifyAttrs[0] = this.hasNotifyAttrs[0] | attrEntry.getSyncMode(0) == 1;
                    this.hasNotifyAttrs[1] = this.hasNotifyAttrs[1] | attrEntry.getSyncMode(1) == 2;
                    this.hasNotifyAttrs[1] = this.hasNotifyAttrs[1] | attrEntry.getSyncMode(1) == 1;
                    if (!attrEntry.getOptimizeModify(1) && (jCClassDef = SchemaCache.getClassDef(this.className)) != null && (stringArray = jCClassDef.getNamingAttributes()) != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            if (attrEntry.attrName.equalsIgnoreCase(stringArray[n])) {
                                attrEntry.pubOptimizeModify = true;
                                break;
                            }
                            ++n;
                        }
                    }
                }
                node = node.getNextSibling();
            }
        }

        public String getName() {
            return this.className;
        }

        public int getSyncMode(int n) {
            return this.syncMode[n];
        }

        public boolean getPubCreateHomeDir() {
            return this.pubCreateHomeDir;
        }

        public boolean getPubTrackTemplate() {
            return this.pubTrackTemplate;
        }

        public AttrEntry getAttrEntry(String string) {
            return (AttrEntry)this.attrs.get(string);
        }

        public Iterator getAttrIterator() {
            return this.attrs.values().iterator();
        }
    }
}

