/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.CommentImpl;
import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.dom.TextImpl;
import java.util.ArrayList;
import novell.jclient.JCContext;
import novell.jclient.JCEntryInfo;
import novell.jclient.JClient;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RuleUtil
implements RuleConstants {
    static final int GETVALUES_POSITIVE = 1;
    static final int GETVALUES_NEGATIVE = 2;
    static final int GETVALUES_FIRSTONLY = 4;
    static final int FOC_ALLOW_ADD = 1;
    static final int FOC_DIRECT_DEST = 2;
    static final int FOC_DIRECT_SRC = 4;
    static final int FOC_PASSWORD = 8;
    static final int FOC_FORCE_CURRENT = 16;
    static final int FOC_FORCE_BEFORE = 32;
    static final int FOC_FORCE_AFTER = 64;

    public static boolean getAttrBoolean(Element element, String string, boolean bl) throws VRDException {
        boolean bl2;
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            bl2 = bl;
        } else if (string2.equals("true")) {
            bl2 = true;
        } else if (string2.equals("false")) {
            bl2 = false;
        } else {
            throw new VRDException(9128, RuleUtil.getNodeLocation(element), string2, string, element.getNodeName());
        }
        return bl2;
    }

    public static String getAttrString(Element element, String string, String string2) throws VRDException {
        String string3 = element.getAttributeNS(null, string);
        if (string3.length() == 0) {
            if (string2 == null) {
                throw new VRDException(9122, RuleUtil.getNodeLocation(element), string, element.getNodeName());
            }
            string3 = string2;
        }
        return string3;
    }

    public static int getAttrInt(Element element, String string, int n) throws VRDException {
        return RuleUtil.getAttrInt(element, string, n, false, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int getAttrInt(Element element, String string, int n, boolean bl, int n2, int n3) throws VRDException {
        int n4;
        String string2 = null;
        try {
            string2 = element.getAttributeNS(null, string);
            if (string2.length() == 0) {
                if (bl) {
                    throw new VRDException(9122, RuleUtil.getNodeLocation(element), string, element.getNodeName());
                }
                n4 = n;
            } else {
                n4 = Integer.parseInt(string2);
                if (n4 < n2 || n4 > n3) {
                    throw new NumberFormatException();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(9128, RuleUtil.getNodeLocation(element), string2, string, element.getNodeName());
        }
        return n4;
    }

    public static int getAttrIndex(Element element, String string, int n, String[] stringArray) throws VRDException {
        int n2;
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            if (n == -1) {
                throw new VRDException(9122, RuleUtil.getNodeLocation(element), string, element.getNodeName());
            }
            n2 = n;
        } else {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.equals(stringArray[n2])) break;
                ++n2;
            }
            if (n2 == stringArray.length) {
                throw new VRDException(9128, RuleUtil.getNodeLocation(element), string2, string, element.getNodeName());
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XdsDN getSrcDN(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        JCContext jCContext;
        Object object;
        String string;
        String string2;
        block9: {
            string2 = "src-dn";
            if (ruleStaticContext.destDelims[0] == '1' && ruleStaticContext.srcDelims[0] != '1') {
                string2 = "qualified-src-dn";
            }
            if ((string = element.getAttributeNS(null, string2)).length() == 0) {
                if (ruleStaticContext.fromNDS && string2 == "qualified-src-dn" && !DirXML.isExternal()) {
                    object = XdsUtil.getSrcEntry(element);
                    if (object == null) {
                        throw new VRDException(9122, RuleUtil.getNodeLocation(element), string2, element.getNodeName());
                    }
                    try {
                        jCContext = MiscDS.createLocalContext();
                        try {
                            ((Entry)object).goTo(jCContext);
                            jCContext.setBaseDN(null, "10.\\+=*'");
                            JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)8192);
                            string = jCContext.standardizeDN(jCEntryInfo.getEntryDN().toString(), null);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            jCContext.free();
                            throw throwable;
                        }
                        jCContext.free();
                        {
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new VRDException(9122, RuleUtil.getNodeLocation(element), string2, element.getNodeName());
                    }
                }
                throw new VRDException(9122, RuleUtil.getNodeLocation(element), string2, element.getNodeName());
            }
        }
        object = new XdsDN(string, ruleStaticContext.srcDelims);
        if (string2 == "qualified-src-dn" && (jCContext = new XdsDN(element.getAttributeNS(null, "src-dn"), ruleStaticContext.srcDelims)).hasTreeName() && !object.hasTreeName()) {
            object.copyTreeName((XdsDN)jCContext);
        }
        return object;
    }

    public static String getNamespaceDecl(Element element, String string) throws VRDException {
        String string2 = "xmlns:" + string;
        String string3 = element.getAttribute(string2);
        if (string3.length() == 0) {
            throw new VRDException(9122, RuleUtil.getNodeLocation(element), string2, element.getNodeName());
        }
        return string3;
    }

    public static Element[] getValues(Element element, String string, int n) {
        String string2;
        if (element.getNamespaceURI() != null) {
            return null;
        }
        if ((n & 3) == 0) {
            return null;
        }
        ArrayList<Node> arrayList = null;
        if ((n & 4) == 0) {
            arrayList = new ArrayList<Node>();
        }
        if ((string2 = element.getLocalName()).equals("add") || string2.equals("instance")) {
            if ((n & 1) == 0) {
                return null;
            }
            String string3 = string2.equals("add") ? "add-attr" : "attr";
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNamespaceURI() == null && string3.equals(node.getLocalName()) && string.equalsIgnoreCase(((Element)node).getAttributeNS(null, "attr-name"))) {
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        if (node2.getNodeType() == 1 && node2.getNamespaceURI() == null && "value".equals(node2.getLocalName())) {
                            if ((n & 4) != 0) {
                                return new Element[]{(Element)node2};
                            }
                            arrayList.add(node2);
                        }
                        node2 = node2.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
        } else if (string2.equals("modify")) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNamespaceURI() == null && "modify-attr".equals(node.getLocalName()) && string.equalsIgnoreCase(((Element)node).getAttributeNS(null, "attr-name"))) {
                    Node node3 = node.getFirstChild();
                    while (node3 != null) {
                        if (node3.getNodeType() == 1 && node3.getNamespaceURI() == null && ("add-value".equals(node3.getLocalName()) && (n & 1) != 0 || "remove-value".equals(node3.getLocalName()) && (n & 2) != 0 || "remove-all-values".equals(node3.getLocalName()) && (n & 2) != 0)) {
                            if ("remove-all-values".equals(node3.getLocalName()) && (n & 4) != 0) {
                                return new Element[]{element.getOwnerDocument().createElementNS(null, "value")};
                            }
                            Node node4 = node3.getFirstChild();
                            while (node4 != null) {
                                if (node4.getNodeType() == 1 && node4.getNamespaceURI() == null && "value".equals(node4.getLocalName())) {
                                    if ((n & 4) != 0) {
                                        return new Element[]{(Element)node4};
                                    }
                                    arrayList.add(node4);
                                }
                                node4 = node4.getNextSibling();
                            }
                        }
                        node3 = node3.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public static Element getSrcInstance(Element element, String string, RuleStaticContext ruleStaticContext, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Node node;
        Object object;
        Element element2 = NdsDtd.createDoc("input");
        Document document = element2.getOwnerDocument();
        Element element3 = document.createElementNS(null, "query");
        element2.appendChild(element3);
        element3.setAttributeNS(null, "scope", "entry");
        XdsUtil.copyAttributeNS(element, null, "class-name", element3);
        XdsUtil.copyAttributeNS(element, null, "src-dn", element3, null, "dest-dn");
        XdsUtil.copyAttributeNS(element, null, "src-entry-id", element3, null, "dest-entry-id");
        if (!ruleStaticContext.fromNDS && (object = XdsUtil.getAssociationValue(element)) != null && ((String)object).length() != 0) {
            node = document.createElementNS(null, "association");
            element3.appendChild(node);
            XdsUtil.setNodeText(node, (String)object);
        }
        object = document.createElementNS(null, "read-attr");
        element3.appendChild((Node)object);
        object.setAttributeNS(null, "attr-name", string);
        node = ruleDynamicContext.srcQueryProcessor.query(document);
        if (document == null) {
            return null;
        }
        return XdsUtil.getFirstElementByTagNameNS(node, null, "instance");
    }

    public static Element getDestInstance(Element element, String string, RuleStaticContext ruleStaticContext, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Node node;
        Object object;
        Element element2 = NdsDtd.createDoc("input");
        Document document = element2.getOwnerDocument();
        Element element3 = document.createElementNS(null, "query");
        element2.appendChild(element3);
        element3.setAttributeNS(null, "scope", "entry");
        XdsUtil.copyAttributeNS(element, null, "class-name", element3);
        boolean bl = XdsUtil.copyAttributeNS(element, null, "dest-dn", element3);
        if ((ruleStaticContext.fromNDS || !(bl |= XdsUtil.copyAttributeNS(element, null, "dest-entry-id", element3))) && (object = XdsUtil.getAssociationValue(element)) != null && ((String)object).length() != 0) {
            node = document.createElementNS(null, "association");
            element3.appendChild(node);
            XdsUtil.setNodeText(node, (String)object);
        }
        object = document.createElementNS(null, "read-attr");
        element3.appendChild((Node)object);
        object.setAttributeNS(null, "attr-name", string);
        node = ruleDynamicContext.destQueryProcessor.query(document);
        if (document == null) {
            return null;
        }
        return XdsUtil.getFirstElementByTagNameNS(node, null, "instance");
    }

    public static Element findValue(Element element, String string, Element element2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getAttributeNS(null, "attr-name").equals(string)) {
                Element element3 = (Element)node;
                Node node2 = element3.getFirstChild();
                while (node2 != null) {
                    if (node2.getNodeType() == 1 && ((Element)node2).getNodeName().equals("value") && RuleUtil.valuesEqual(element2, (Element)node2)) {
                        return (Element)node2;
                    }
                    node2 = node2.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static boolean addValue(Element element, String string, Element element2, boolean bl, RuleStaticContext ruleStaticContext) {
        Node node;
        Node node2 = null;
        Node node3 = element.getFirstChild();
        while (node3 != null) {
            if (node3.getNodeType() == 1 && ((Element)node3).getAttributeNS(null, "attr-name").equals(string)) {
                node2 = (Element)node3;
                node = node2.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1 && ((Element)node).getNodeName().equals("value")) {
                        if (!bl) {
                            if (ruleStaticContext.tracer.getLevel() >= 3) {
                                ruleStaticContext.tracer.trace(3, "rct_skipping_value_not_needed", (MessageSource)RuleConstants.messageSource, (Object)string, (Object)RuleUtil.makeTraceValue(element2));
                            }
                            return false;
                        }
                        if (RuleUtil.valuesEqual(element2, (Element)node)) {
                            if (ruleStaticContext.tracer.getLevel() >= 3) {
                                ruleStaticContext.tracer.trace("rct_skipping_value_dup", (MessageSource)RuleConstants.messageSource, string, (Object)RuleUtil.makeTraceValue(element2));
                            }
                            return false;
                        }
                    }
                    node = node.getNextSibling();
                }
            }
            node3 = node3.getNextSibling();
        }
        if (node2 == null) {
            if (ruleStaticContext.tracer.getLevel() >= 3) {
                ruleStaticContext.tracer.trace("rct_adding_value", (MessageSource)RuleConstants.messageSource, string, (Object)RuleUtil.makeTraceValue(element2));
            }
            node = element.getOwnerDocument();
            String string2 = element.getNodeName().equals("add") ? "add-attr" : (element.getNodeName().equals("query") ? "search-attr" : "attr");
            node2 = node.createElementNS(null, string2);
            node2.setAttributeNS(null, "attr-name", string);
            RuleUtil.addAttr(element, (Element)node2);
        }
        node2.appendChild(element2);
        return true;
    }

    public static void addAttr(Element element, Element element2) {
        element.insertBefore(element2, XdsUtil.getFirstChildElementByTagNameNS(element, null, "password"));
        Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "operation-data");
        int n = 0;
        while (n < elementArray.length) {
            element.removeChild(elementArray[n]);
            element.appendChild(elementArray[n]);
            ++n;
        }
    }

    public static boolean valuesEqual(Element element, Element element2) {
        Element[] elementArray;
        Element[] elementArray2 = XdsUtil.getChildElementsByTagNameNS(element, null, "component");
        if (elementArray2.length != (elementArray = XdsUtil.getChildElementsByTagNameNS(element2, null, "component")).length) {
            return false;
        }
        if (elementArray2.length != 0) {
            int n = elementArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string = elementArray2[n2].getAttributeNS(null, "name");
                int n3 = 0;
                while (n3 < n) {
                    if (elementArray[n3] != null && string.equals(elementArray[n3].getAttributeNS(null, "name"))) break;
                    ++n3;
                }
                if (n3 >= n) {
                    return false;
                }
                if (!XdsUtil.getNodeText(elementArray2[n2]).equals(XdsUtil.getNodeText(elementArray[n3]))) {
                    return false;
                }
                elementArray[n3] = null;
                ++n2;
            }
            return true;
        }
        return XdsUtil.getNodeText(element).equals(XdsUtil.getNodeText(element2));
    }

    public static String getNodeLocation(Node node) {
        int n = 0;
        String string = "";
        if (node instanceof NodeImpl && (string = ((NodeImpl)node).getBaseURI()) != null && string.length() > 0 && (n = ((NodeImpl)node).getLineNumber()) > 0) {
            string = string + ":" + n;
        }
        return string;
    }

    public static String makeTraceValue(Element element) {
        Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "component");
        if (elementArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < elementArray.length) {
                if (n > 0) {
                    stringBuffer.append("#");
                }
                stringBuffer.append(XdsUtil.getNodeText(elementArray[n]));
                ++n;
            }
            return stringBuffer.toString();
        }
        return XdsUtil.getNodeText(element);
    }

    public static String[] getEntitlementValues(Element[] elementArray, String string, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(elementArray.length);
        int n = 0;
        while (n < elementArray.length) {
            Element[] elementArray2 = XdsUtil.getChildElementsByTagNameNS(elementArray[n], null, "component");
            if (elementArray2.length >= 3 && string.equalsIgnoreCase(XdsUtil.getNodeText(elementArray2[0])) && string2.equalsIgnoreCase(XdsUtil.getNodeText(elementArray2[2]))) {
                arrayList.add(XdsUtil.getNodeText(elementArray2[1]));
                if (bl) break;
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int guessStructuredSyntaxFromComponentName(String string) {
        if (string.equalsIgnoreCase("octet")) {
            return 13;
        }
        if (string.equalsIgnoreCase("string")) {
            return 6;
        }
        if (string.equalsIgnoreCase("eMailType") || string.equalsIgnoreCase("eMailAddr")) {
            return 14;
        }
        if (string.equalsIgnoreCase("faxNumber") || string.equalsIgnoreCase("faxBitCount") || string.equalsIgnoreCase("faxParameters")) {
            return 11;
        }
        if (string.equalsIgnoreCase("holdEntryDn") || string.equalsIgnoreCase("holdAmount")) {
            return 26;
        }
        if (string.equalsIgnoreCase("netAddrType") || string.equalsIgnoreCase("netAddr")) {
            return 12;
        }
        if (string.equalsIgnoreCase("protectedName") || string.equalsIgnoreCase("trustee") || string.equalsIgnoreCase("privileges")) {
            return 17;
        }
        if (string.equalsIgnoreCase("nameSpace") || string.equalsIgnoreCase("volume") || string.equalsIgnoreCase("path")) {
            return 15;
        }
        if (string.equalsIgnoreCase("server") || string.equalsIgnoreCase("replicaType") || string.equalsIgnoreCase("replicaNumber") || string.equalsIgnoreCase("count")) {
            return 16;
        }
        if (string.equalsIgnoreCase("seconds") || string.equalsIgnoreCase("replicaNumber") || string.equalsIgnoreCase("eventId")) {
            return 19;
        }
        if (string.equalsIgnoreCase("dn") || string.equalsIgnoreCase("level") || string.equalsIgnoreCase("interval")) {
            return 25;
        }
        return 0;
    }

    public static Element findOrCreateModOperation(Element element, String string, String string2, String string3, int n) {
        Node node;
        Element element2;
        Node node2;
        Element element3 = null;
        if ((n & 0x46) != 0) {
            n &= 0xFFFFFFDF;
            n |= 0x40;
        }
        if ((n & 0x10) != 0) {
            element3 = element;
        } else {
            if (string.length() == 0 && string2.length() == 0) {
                return null;
            }
            node2 = element;
            element2 = null;
            if ((n & 0x20) != 0) {
                node2 = element.getParentNode().getFirstChild();
                element2 = element;
            } else if ((n & 0x40) != 0) {
                node2 = element.getNextSibling();
            }
            node = node2;
            while (node != null && node != element2) {
                if (node.getNodeType() == 1) {
                    String string4 = ((Element)node).getAttributeNS(null, "direct");
                    if ((n & 2) != 0 && string4.equals("dest") || (n & 4) != 0 && string4.equals("src") || (n & 6) == 0 && string4.length() == 0) {
                        element3 = (Element)node;
                    }
                }
                node = node.getNextSibling();
            }
        }
        if (element3 != null && element3.getNamespaceURI() == null && ((n & 8) == 0 && element3.getLocalName().equals("modify") || (n & 1) != 0 && element3.getLocalName().equals("add")) && (string.length() == 0 || string.equals(XdsUtil.getAssociationValue(element3))) && (string2.length() == 0 || string2.equals(element3.getAttributeNS(null, "dest-dn"))) && (string3.length() == 0 || string3.equals(element3.getAttributeNS(null, "class-name")))) {
            return element3;
        }
        node2 = element.getOwnerDocument();
        element2 = node2.createElementNS(null, (n & 8) != 0 ? "modify-password" : "modify");
        if ((n & 0x20) != 0) {
            element.getParentNode().insertBefore(element2, element);
        } else {
            element.getParentNode().appendChild(element2);
        }
        XdsUtil.copyAttributeNS(element, null, "event-id", element2);
        if (string2.length() != 0) {
            element2.setAttributeNS(null, "dest-dn", string2);
        }
        if (string3.length() != 0) {
            element2.setAttributeNS(null, "class-name", string3);
        }
        if (string.length() != 0) {
            node = node2.createElementNS(null, "association");
            element2.appendChild(node);
            XdsUtil.setNodeText(node, string);
        }
        if ((n & 4) != 0) {
            element2.setAttributeNS(null, "direct", "src");
        } else if ((n & 2) != 0) {
            element2.setAttributeNS(null, "direct", "dest");
        }
        return element2;
    }

    public static void updateSandboxDocumentOrder(RuleDynamicContext ruleDynamicContext) {
        if (ruleDynamicContext.sandBoxFragment != null && ruleDynamicContext.sandBoxFragment instanceof DocumentFragmentImpl) {
            ((DocumentFragmentImpl)ruleDynamicContext.sandBoxFragment).updateDocumentOrder();
        }
    }

    public static Text createSandboxTextNode(String string, RuleDynamicContext ruleDynamicContext) {
        Document document = ruleDynamicContext.sandBoxFragment.getOwnerDocument();
        Text text = document.createTextNode(string);
        if (ruleDynamicContext.sandBoxFragment != null && ruleDynamicContext.sandBoxFragment instanceof DocumentFragmentImpl) {
            DocumentFragmentImpl documentFragmentImpl = (DocumentFragmentImpl)ruleDynamicContext.sandBoxFragment;
            boolean bl = documentFragmentImpl.isOrderCurrent();
            NodeImpl nodeImpl = (NodeImpl)documentFragmentImpl.getLastChild();
            Comment comment = document.createComment("");
            documentFragmentImpl.appendChild((Node)comment);
            documentFragmentImpl.appendChild((Node)text);
            if (nodeImpl != null) {
                ((CommentImpl)comment).setDocumentOrder(nodeImpl.getDocumentOrder() + 0.5);
                ((TextImpl)text).setDocumentOrder(nodeImpl.getDocumentOrder() + 1.0);
                documentFragmentImpl.setOrderCurrent(bl);
            }
        } else {
            ruleDynamicContext.sandBoxFragment.appendChild(text);
        }
        return text;
    }

    public static XdsDN parseDN(String string, char[] cArray) throws VRDException {
        XdsDN xdsDN = new XdsDN(string, cArray);
        if (xdsDN.getParseErr() != 0) {
            throw new VRDException(9172, string);
        }
        return xdsDN;
    }
}

