/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.CaseIgnoreStringKey;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleProcessor;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaMappingRuleProcessor
implements RuleProcessor,
RuleConstants {
    private RuleStaticContext staticContext;
    private HashMap classMap = new HashMap();
    private HashMap attrMap = new HashMap();
    private RuleProcessor nextRule;

    public SchemaMappingRuleProcessor(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        Object object;
        Object object2;
        String string;
        String string2;
        this.staticContext = ruleStaticContext;
        if (element.getNamespaceURI() != null || !element.getLocalName().equals("attr-name-map")) {
            throw new VRDException(9127, RuleUtil.getNodeLocation(element), (Object)"attr-name-map");
        }
        if (ruleStaticContext.fromNDS) {
            string2 = "nds-name";
            string = "app-name";
        } else {
            string2 = "app-name";
            string = "nds-name";
        }
        NodeList nodeList = element.getElementsByTagNameNS(null, "class-name");
        int n = 0;
        while (n < nodeList.getLength()) {
            object2 = (Element)nodeList.item(n);
            CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey(SchemaMappingRuleProcessor.getMapName((Element)object2, string2));
            object = SchemaMappingRuleProcessor.getMapName((Element)object2, string);
            if (this.classMap.containsKey(caseIgnoreStringKey)) {
                StatusLog.logWarning(8030, "class-name", caseIgnoreStringKey.toString());
            }
            this.classMap.put(caseIgnoreStringKey, object);
            ++n;
        }
        object2 = element.getElementsByTagNameNS(null, "attr-name");
        int n2 = 0;
        while (n2 < object2.getLength()) {
            object = (Element)object2.item(n2);
            String string3 = object.getAttributeNS(null, "class-name");
            String string4 = SchemaMappingRuleProcessor.getMapName((Element)object, string2);
            String string5 = SchemaMappingRuleProcessor.getMapName((Element)object, string);
            CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey(string3 + "::" + string4);
            if (this.attrMap.containsKey(caseIgnoreStringKey)) {
                StatusLog.logWarning(8030, "attr-name", caseIgnoreStringKey.toString());
            }
            this.attrMap.put(caseIgnoreStringKey, string5);
            ++n2;
        }
    }

    private static String getMapName(Element element, String string) throws VRDException {
        Element element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, string);
        if (element2 == null) {
            throw new VRDException(9025, string);
        }
        String string2 = XdsUtil.getNodeText(element2);
        if (string2.length() == 0) {
            throw new VRDException(9027, string);
        }
        return string2;
    }

    public Document applyRules(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.staticContext.tracer.pushIndent(1);
        try {
            block12: {
                try {
                    Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(document, "*", "*", null, "attr-name");
                    if (!this.staticContext.fromNDS) {
                        this.fixClassNames(document);
                    }
                    int n = 0;
                    while (n < elementArray.length) {
                        String string = elementArray[n].getAttributeNS(null, "attr-name");
                        Element element = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(elementArray[n], "*", "*", null, "class-name");
                        String string2 = element == null ? "" : element.getAttributeNS(null, "class-name");
                        String string3 = (String)this.attrMap.get(new CaseIgnoreStringKey(string2 + "::" + string));
                        if (string3 != null) {
                            elementArray[n].setAttributeNS(null, "attr-name", string3);
                            this.staticContext.tracer.trace(3, "rct_matto", (MessageSource)RuleConstants.messageSource, (Object)string, (Object)string3);
                        } else if (string2.length() != 0) {
                            string3 = (String)this.attrMap.get(new CaseIgnoreStringKey("::" + string));
                            if (string3 != null) {
                                elementArray[n].setAttributeNS(null, "attr-name", string3);
                                this.staticContext.tracer.trace(3, "rct_matto", (MessageSource)RuleConstants.messageSource, (Object)string, (Object)string3);
                            }
                        } else {
                            this.staticContext.tracer.trace(3, "rct_nmatt", (MessageSource)RuleConstants.messageSource, (Object)string);
                        }
                        ++n;
                    }
                    if (!this.staticContext.fromNDS) break block12;
                    this.fixClassNames(document);
                }
                catch (Exception exception) {
                    throw new VRDException(exception);
                }
            }
            Object var10_10 = null;
            this.staticContext.tracer.popIndent();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.staticContext.tracer.popIndent();
            throw throwable;
        }
        if (this.nextRule != null) {
            document = this.nextRule.applyRules(document, ruleDynamicContext);
        }
        return document;
    }

    void fixClassNames(Document document) {
        Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(document, "*", "*", null, "class-name");
        int n = 0;
        while (n < elementArray.length) {
            String string = elementArray[n].getAttributeNS(null, "class-name");
            String string2 = (String)this.classMap.get(new CaseIgnoreStringKey(string));
            if (string2 != null) {
                elementArray[n].setAttributeNS(null, "class-name", string2);
                this.staticContext.tracer.trace(3, "rct_mclsto", (MessageSource)RuleConstants.messageSource, (Object)string, (Object)string2);
            } else {
                this.staticContext.tracer.trace(3, "rct_nmcls", (MessageSource)RuleConstants.messageSource, (Object)string);
            }
            ++n;
        }
    }

    public void setNextRule(RuleProcessor ruleProcessor) {
        this.nextRule = ruleProcessor;
    }
}

