/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.TokenAddedEntitlement;
import com.novell.nds.dirxml.engine.rules.TokenAssociation;
import com.novell.nds.dirxml.engine.rules.TokenAttr;
import com.novell.nds.dirxml.engine.rules.TokenClassName;
import com.novell.nds.dirxml.engine.rules.TokenDestAttr;
import com.novell.nds.dirxml.engine.rules.TokenDestDN;
import com.novell.nds.dirxml.engine.rules.TokenDestName;
import com.novell.nds.dirxml.engine.rules.TokenEntitlement;
import com.novell.nds.dirxml.engine.rules.TokenEscapeForDestDN;
import com.novell.nds.dirxml.engine.rules.TokenEscapeForSrcDN;
import com.novell.nds.dirxml.engine.rules.TokenGlobalVariable;
import com.novell.nds.dirxml.engine.rules.TokenLocalVariable;
import com.novell.nds.dirxml.engine.rules.TokenLowerCase;
import com.novell.nds.dirxml.engine.rules.TokenNamedPassword;
import com.novell.nds.dirxml.engine.rules.TokenOpAttr;
import com.novell.nds.dirxml.engine.rules.TokenOpProperty;
import com.novell.nds.dirxml.engine.rules.TokenOperation;
import com.novell.nds.dirxml.engine.rules.TokenParseDN;
import com.novell.nds.dirxml.engine.rules.TokenPassword;
import com.novell.nds.dirxml.engine.rules.TokenRemovedAttr;
import com.novell.nds.dirxml.engine.rules.TokenRemovedEntitlement;
import com.novell.nds.dirxml.engine.rules.TokenReplaceAll;
import com.novell.nds.dirxml.engine.rules.TokenReplaceFirst;
import com.novell.nds.dirxml.engine.rules.TokenSrcAttr;
import com.novell.nds.dirxml.engine.rules.TokenSrcDN;
import com.novell.nds.dirxml.engine.rules.TokenSrcName;
import com.novell.nds.dirxml.engine.rules.TokenSubstring;
import com.novell.nds.dirxml.engine.rules.TokenText;
import com.novell.nds.dirxml.engine.rules.TokenUniqueName;
import com.novell.nds.dirxml.engine.rules.TokenUnmatchedSrcDN;
import com.novell.nds.dirxml.engine.rules.TokenUpperCase;
import com.novell.nds.dirxml.engine.rules.TokenXPath;
import org.w3c.dom.Element;

abstract class Token
implements RuleConstants {
    protected RuleStaticContext staticContext;
    protected String display;
    protected String location;
    protected boolean nodesetContext;

    Token(Element element, RuleStaticContext ruleStaticContext, boolean bl) {
        this.staticContext = ruleStaticContext;
        this.nodesetContext = bl;
        this.location = RuleUtil.getNodeLocation(element);
        this.display = RuleConstants.displayString.getTokenString(element);
        if (this instanceof TokenText) {
            this.display = "token-text(" + this.display + ")";
        }
    }

    abstract Object expand(Element var1, RuleDynamicContext var2) throws VRDException;

    static Token createToken(Element element, RuleStaticContext ruleStaticContext, boolean bl) throws VRDException {
        if (element.getNamespaceURI() != null) {
            throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), element.getParentNode().getNodeName());
        }
        String string = element.getLocalName();
        if (string.equals("token-added-entitlement")) {
            return new TokenAddedEntitlement(element, ruleStaticContext, bl);
        }
        if (string.equals("token-association")) {
            return new TokenAssociation(element, ruleStaticContext, bl);
        }
        if (string.equals("token-attr")) {
            return new TokenAttr(element, ruleStaticContext, bl);
        }
        if (string.equals("token-class-name")) {
            return new TokenClassName(element, ruleStaticContext, bl);
        }
        if (string.equals("token-dest-attr")) {
            return new TokenDestAttr(element, ruleStaticContext, bl);
        }
        if (string.equals("token-dest-dn")) {
            return new TokenDestDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-dest-name")) {
            return new TokenDestName(element, ruleStaticContext, bl);
        }
        if (string.equals("token-entitlement")) {
            return new TokenEntitlement(element, ruleStaticContext, bl);
        }
        if (string.equals("token-escape-for-dest-dn")) {
            return new TokenEscapeForDestDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-escape-for-src-dn")) {
            return new TokenEscapeForSrcDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-global-variable")) {
            return new TokenGlobalVariable(element, ruleStaticContext, bl);
        }
        if (string.equals("token-local-variable")) {
            return new TokenLocalVariable(element, ruleStaticContext, bl);
        }
        if (string.equals("token-lower-case")) {
            return new TokenLowerCase(element, ruleStaticContext, bl);
        }
        if (string.equals("token-named-password")) {
            return new TokenNamedPassword(element, ruleStaticContext, bl);
        }
        if (string.equals("token-op-attr")) {
            return new TokenOpAttr(element, ruleStaticContext, bl);
        }
        if (string.equals("token-op-property")) {
            return new TokenOpProperty(element, ruleStaticContext, bl);
        }
        if (string.equals("token-operation")) {
            return new TokenOperation(element, ruleStaticContext, bl);
        }
        if (string.equals("token-parse-dn")) {
            return new TokenParseDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-password")) {
            return new TokenPassword(element, ruleStaticContext, bl);
        }
        if (string.equals("token-removed-attr")) {
            return new TokenRemovedAttr(element, ruleStaticContext, bl);
        }
        if (string.equals("token-removed-entitlement")) {
            return new TokenRemovedEntitlement(element, ruleStaticContext, bl);
        }
        if (string.equals("token-replace-all")) {
            return new TokenReplaceAll(element, ruleStaticContext, bl);
        }
        if (string.equals("token-replace-first")) {
            return new TokenReplaceFirst(element, ruleStaticContext, bl);
        }
        if (string.equals("token-src-attr")) {
            return new TokenSrcAttr(element, ruleStaticContext, bl);
        }
        if (string.equals("token-src-dn")) {
            return new TokenSrcDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-src-name")) {
            return new TokenSrcName(element, ruleStaticContext, bl);
        }
        if (string.equals("token-substring")) {
            return new TokenSubstring(element, ruleStaticContext, bl);
        }
        if (string.equals("token-text")) {
            return new TokenText(element, ruleStaticContext, bl);
        }
        if (string.equals("token-unique-name")) {
            return new TokenUniqueName(element, ruleStaticContext, bl);
        }
        if (string.equals("token-unmatched-src-dn")) {
            return new TokenUnmatchedSrcDN(element, ruleStaticContext, bl);
        }
        if (string.equals("token-upper-case")) {
            return new TokenUpperCase(element, ruleStaticContext, bl);
        }
        if (string.equals("token-xpath")) {
            return new TokenXPath(element, ruleStaticContext, bl);
        }
        throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), element.getParentNode().getNodeName());
    }
}

