/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.Token;
import com.novell.nds.dirxml.util.XdsDN;
import org.w3c.dom.Element;

class TokenParseDN
extends Token {
    private Arg arg;
    private int start;
    private int length;
    private int srcFormat;
    private int destFormat;
    private char[] customSrcDelims = null;
    private char[] customDestDelims = null;
    private static final int SRC_FORM = 6;
    private static final int DEST_FORM = 7;
    private static final String[] DN_FORMAT_TABLE = new String[]{"slash", "qualified-slash", "dot", "qualified-dot", "ldap", "custom", "src-dn", "dest-dn"};

    TokenParseDN(Element element, RuleStaticContext ruleStaticContext, boolean bl) throws VRDException {
        super(element, ruleStaticContext, bl);
        String string;
        this.arg = new Arg(element, ruleStaticContext);
        this.start = RuleUtil.getAttrInt(element, "start", 0);
        this.length = RuleUtil.getAttrInt(element, "length", -1);
        this.srcFormat = RuleUtil.getAttrIndex(element, "src-dn-format", 6, DN_FORMAT_TABLE);
        this.destFormat = RuleUtil.getAttrIndex(element, "dest-dn-format", 7, DN_FORMAT_TABLE);
        if (this.srcFormat == 5) {
            string = RuleUtil.getAttrString(element, "src-dn-delims", null);
            this.customSrcDelims = string.toCharArray();
            if (!XdsDN.validateDelims((char[])this.customSrcDelims)) {
                throw new VRDException(9128, RuleUtil.getNodeLocation(element), string, "src-dn-delims", element.getNodeName());
            }
        }
        if (this.destFormat == 5) {
            string = RuleUtil.getAttrString(element, "dest-dn-delims", null);
            this.customDestDelims = string.toCharArray();
            if (!XdsDN.validateDelims((char[])this.customDestDelims)) {
                throw new VRDException(9128, RuleUtil.getNodeLocation(element), string, "dest-dn-delims", element.getNodeName());
            }
        }
    }

    private char[] getDelims(int n, char[] cArray) {
        switch (n) {
            case 5: {
                return cArray;
            }
            case 6: {
                return this.staticContext.srcDelims;
            }
            case 7: {
                return this.staticContext.destDelims;
            }
        }
        return XdsDN.getDelims((int)n).toCharArray();
    }

    Object expand(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        String string = this.arg.evaluate(element, ruleDynamicContext).toString();
        XdsDN xdsDN = RuleUtil.parseDN(string, this.getDelims(this.srcFormat, this.customSrcDelims));
        return xdsDN.getDNFragment(this.getDelims(this.destFormat, this.customDestDelims), this.start, this.length, true);
    }
}

