/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.Token;
import com.novell.nds.dirxml.util.XdsDN;
import org.w3c.dom.Element;

class TokenUnmatchedSrcDN
extends Token {
    private boolean convert;

    TokenUnmatchedSrcDN(Element element, RuleStaticContext ruleStaticContext, boolean bl) throws VRDException {
        super(element, ruleStaticContext, bl);
        this.convert = RuleUtil.getAttrBoolean(element, "convert", false);
    }

    Object expand(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        XdsDN xdsDN;
        if (this.convert) {
            xdsDN = RuleUtil.getSrcDN(element, this.staticContext);
        } else {
            String string = element.getAttributeNS(null, "src-dn");
            xdsDN = RuleUtil.parseDN(string, this.staticContext.srcDelims);
        }
        int n = ruleDynamicContext.unmatchedSrcDnComponentCount;
        if (n == -1) {
            n = xdsDN.getComponentCount();
        }
        return xdsDN.getRDN(this.convert ? this.staticContext.destDelims : this.staticContext.srcDelims, n);
    }
}

