/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.VRDExceptionListener;
import com.novell.nds.dirxml.engine.rules.DNConverterImpl;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleProcessor;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.XmlHook;
import com.novell.xsl.result.DOMResultHandler;
import com.novell.xsl.result.ResultHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTRuleProcessor
implements RuleProcessor,
RuleConstants,
ErrorHandler,
MessageHandler,
VRDExceptionListener {
    private RuleStaticContext staticContext;
    private Stylesheet styleSheet;
    private RuleProcessor nextRule;
    private static DNConverterImpl dnConverter = new DNConverterImpl();
    private int warningCount = 0;
    private int errorCount = 0;
    private VRDException queryException = null;

    public XSLTRuleProcessor(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        this.staticContext = ruleStaticContext;
        try {
            DocumentImpl documentImpl;
            Document document;
            ConfigAbstraction configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry");
            this.styleSheet = new Stylesheet(ruleStaticContext.loader);
            this.styleSheet.setMessageHandler((MessageHandler)this);
            this.styleSheet.setErrorHandler((ErrorHandler)this);
            if (configAbstraction != null) {
                this.styleSheet.setXmlHook((XmlHook)configAbstraction);
                this.styleSheet.setBrokenMode(configAbstraction.getECVs().getXSLTBrokenMode());
            }
            if ((document = element.getOwnerDocument()) != element.getParentNode()) {
                documentImpl = (DocumentImpl)DocumentFactory.newDocument();
                documentImpl.appendChild(documentImpl.importNode((Node)element, true));
                DOMUtil.addNamespaceDecls((Node)documentImpl);
                if (element instanceof NodeImpl) {
                    documentImpl.setBaseURI(((NodeImpl)element).getBaseURI());
                }
                document = documentImpl;
            }
            if (document instanceof NodeImpl && (documentImpl = (NodeImpl)document).getBaseURI() != null) {
                this.styleSheet.setBaseURI(documentImpl.getBaseURI());
            }
            this.styleSheet.load(document);
        }
        catch (Exception exception) {
            throw new VRDException(exception);
        }
        if (this.errorCount > 0) {
            throw new VRDException(9014, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document applyRules(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        VRDException vRDException;
        Document document2;
        block9: {
            document2 = DocumentFactory.newDocument();
            DOMResultHandler dOMResultHandler = new DOMResultHandler(document2);
            this.staticContext.tracer.trace("rct_appsty", (MessageSource)RuleConstants.messageSource);
            ruleDynamicContext.exceptionListener = this;
            vRDException = null;
            this.staticContext.tracer.pushIndent(1);
            try {
                try {
                    this.styleSheet.setResultHandler((ResultHandler)dOMResultHandler);
                    this.styleSheet.setParameter("fromNds", (Object)new Boolean(this.staticContext.fromNDS));
                    this.styleSheet.setParameter("srcQueryProcessor", (Object)ruleDynamicContext.srcQueryProcessor);
                    this.styleSheet.setParameter("destQueryProcessor", (Object)ruleDynamicContext.destQueryProcessor);
                    this.styleSheet.setParameter("srcCommandProcessor", (Object)ruleDynamicContext.srcCommandProcessor);
                    this.styleSheet.setParameter("destCommandProcessor", (Object)ruleDynamicContext.destCommandProcessor);
                    this.styleSheet.setParameter("dnConverter", (Object)dnConverter);
                    this.styleSheet.setMessageHandler((MessageHandler)this);
                    this.styleSheet.setErrorHandler((ErrorHandler)this);
                    this.styleSheet.process((Node)document, null);
                    if (this.errorCount > 0 && this.queryException == null) {
                        throw new VRDException(9037);
                    }
                    Object var8_6 = null;
                    vRDException = this.queryException;
                    this.resetCounts();
                }
                catch (XSLException xSLException) {
                    if (this.queryException == null) {
                        throw new VRDException(xSLException);
                    }
                    Object var8_7 = null;
                    vRDException = this.queryException;
                    this.resetCounts();
                    this.styleSheet.clearParameters();
                    this.staticContext.tracer.popIndent();
                    ruleDynamicContext.exceptionListener = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                vRDException = this.queryException;
                this.resetCounts();
                this.styleSheet.clearParameters();
                this.staticContext.tracer.popIndent();
                ruleDynamicContext.exceptionListener = null;
                throw throwable;
            }
            this.styleSheet.clearParameters();
            this.staticContext.tracer.popIndent();
            ruleDynamicContext.exceptionListener = null;
        }
        if (vRDException != null) {
            throw vRDException;
        }
        if (this.staticContext.tracer.getLevel() >= 3) {
            this.staticContext.tracer.trace("rct_rulret", (MessageSource)RuleConstants.messageSource);
            this.staticContext.tracer.trace(document2);
        }
        if (this.nextRule == null) return document2;
        return this.nextRule.applyRules(document2, ruleDynamicContext);
    }

    public void setNextRule(RuleProcessor ruleProcessor) {
        this.nextRule = ruleProcessor;
    }

    public void error(String string) throws XSLException {
        if (this.queryException == null) {
            ++this.errorCount;
        } else {
            throw new XSLException("");
        }
        StatusLog.log(new VRDException(9061, string));
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void resetCounts() {
        this.warningCount = 0;
        this.errorCount = 0;
        this.queryException = null;
    }

    public void warning(String string) {
        ++this.warningCount;
        StatusLog.logWarning(8004, string);
    }

    public void message(Node node) {
        try {
            Node node2;
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("%13Cxsl:message");
            short s = node.getNodeType();
            if (s == 9 || s == 11) {
                node2 = node.getFirstChild();
                if (node2 != null && node2.getNextSibling() == null && node2.getNodeType() == 3) {
                    stringWriter.write(" -> ");
                    stringWriter.write(node2.getNodeValue());
                } else {
                    stringWriter.write("\n");
                    DOMUtil.printFragment((Writer)stringWriter, (Node)node);
                }
            } else {
                stringWriter.write("\n");
                DOMUtil.printFragment((Writer)stringWriter, (Node)node);
            }
            this.staticContext.tracer.trace(0, stringWriter.toString());
            if (s == 9 || s == 11) {
                node2 = node.getFirstChild();
                while (node2 != null) {
                    if (node2.getNodeType() == 1 && node2.getNodeName().equals("status")) {
                        Element element = (Element)node2;
                        StatusLog.log(element);
                        String string = element.getAttributeNS(null, "level");
                        if (string.equals("fatal")) {
                            this.exceptionNotify(new VRDException(9173, StatusLog.getStatusMessage(element)));
                        } else if (string.equals("retry")) {
                            this.exceptionNotify(new VRDException(9174, StatusLog.getStatusMessage(element)));
                        }
                    }
                    node2 = node2.getNextSibling();
                }
            }
        }
        catch (IOException iOException) {
            StatusLog.log(iOException);
        }
    }

    public void exceptionNotify(VRDException vRDException) {
        if (this.queryException == null) {
            this.queryException = vRDException;
        }
    }
}

