/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dhutil.SPMAgent;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.io.EndianOutputStream;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCPathValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class CheckObjectPassword
implements SubVerbHandler {
    protected long driverEntryID;
    protected long objectEntryID;
    protected int result;
    Entry entry;
    Entry driver;
    DriverEntry driverEntry;

    CheckObjectPassword() {
    }

    protected void getWireData(long l, PositionInputStream positionInputStream) throws DSErr {
        try {
            int n = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n != 0) {
                this.result = -641;
                throw new DSErr(this.result);
            }
            int n2 = DSWire.WGetInt32((InputStream)positionInputStream);
            long l2 = DirXMLVerbs.resolveDN(DSWire.WGetString((InputStream)positionInputStream), n2);
            if (!DirXMLVerbs.hasSupervisorRights(l2, l)) {
                this.result = -672;
                throw new DSErr(this.result);
            }
            DSWire.WGetAlign32((PositionInputStream)positionInputStream);
            n2 = DSWire.WGetInt32((InputStream)positionInputStream);
            this.driverEntryID = DirXMLVerbs.resolveDN(DSWire.WGetString((InputStream)positionInputStream), n2);
            if (!DirXMLVerbs.hasSupervisorRights(this.driverEntryID, l)) {
                this.result = -672;
                throw new DSErr(this.result);
            }
            DSWire.WGetAlign32((PositionInputStream)positionInputStream);
            this.entry = new Entry(l2);
            this.driver = new Entry(this.driverEntryID);
            this.driverEntry = DriverList.findEntry(this.driverEntryID);
            if (this.driverEntry == null) {
                StatusLog.logError(9139, this.getSubVerbName(), DDSServ.getLocalEntryName((long)this.driverEntryID, (int)0));
                this.result = 9139;
                throw new DSErr(-641);
            }
        }
        catch (IOException iOException) {
            String string = iOException.getLocalizedMessage() + "(1)";
            StatusLog.logError(9140, this.getSubVerbName(), string);
            this.result = 9140;
            throw new DSErr(-641);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] processSubVerb(long l, int n, PositionInputStream positionInputStream, int n2) throws DSErr {
        byte[] byArray;
        block22: {
            block21: {
                JCContext jCContext = null;
                this.result = 0;
                this.getWireData(l, positionInputStream);
                jCContext = new JCContext();
                jCContext.setFlags(4, 128);
                jCContext.setBaseDN("\\", "00.\\+=*'");
                jCContext.setLocal(0);
                this.entry.initDN(jCContext);
                String string = jCContext.standardizeDN(this.entry.getDN(), null);
                this.driver.initDN(jCContext);
                String string2 = jCContext.standardizeDN(this.driver.getDN(), null);
                String string3 = MiscDS.getTreeName();
                long l2 = 0L;
                SPMAgent.PasswordInfo passwordInfo = SPMAgent.getSPMDistPassword((String)"Agent Dirxml", (String)string2, (String)string3, (String)string, (long)l2);
                jCContext.setEntryID(this.objectEntryID);
                JCValue[] jCValueArray = this.getAssociations(jCContext, string2, this.entry);
                if (jCValueArray == null) {
                    this.result = 8019;
                } else if (passwordInfo == null) {
                    this.result = 9046;
                } else {
                    Element element = NdsDtd.createDoc("input");
                    Document document = element.getOwnerDocument();
                    Element element2 = document.createElementNS(null, "check-object-password");
                    element.appendChild(element2);
                    element2.setAttributeNS(null, "event-id", "user-agent-check-password");
                    element2.appendChild(NdsDtd.createAssociationElement(document, ((JCPathValue)jCValueArray[0]).getVolumePath(), -1));
                    Element element3 = document.createElementNS(null, "password");
                    element2.appendChild(element3);
                    XdsUtil.setNodeText(element3, passwordInfo.getPassword());
                    Document document2 = this.driverEntry.submitAction(document);
                    Element element4 = XdsUtil.getFirstElementByTagNameNS(document2, null, "output");
                    Element element5 = null;
                    if (element4 != null) {
                        element5 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element4, null, "status", null, "event-id", "user-agent-check-password");
                    }
                    this.result = 9046;
                    if (element5 != null) {
                        int n3 = NdsDtd.getStatusLevel(element5);
                        if (n3 == 0) {
                            this.result = 0;
                        } else if (n3 == 1) {
                            this.result = 9006;
                        }
                    }
                    if (this.result != 0 && this.result != 9006) {
                        element = NdsDtd.createDoc("input");
                        document = element.getOwnerDocument();
                        Element element6 = document.createElementNS(null, "query");
                        element.appendChild(element6);
                        element6.appendChild(NdsDtd.createAssociationElement(document, ((JCPathValue)jCValueArray[0]).getVolumePath(), -1));
                        element6.setAttributeNS(null, "scope", "entry");
                        document2 = this.driverEntry.submitAction(document);
                        Element element7 = XdsUtil.getFirstElementByTagNameNS(document2, null, "output");
                        Element element8 = null;
                        if (element7 != null) {
                            element8 = XdsUtil.getFirstChildElementByTagNameNS(element7, null, "instance");
                        }
                        this.result = element8 != null ? 9046 : 8019;
                    }
                }
                if (jCContext == null) break block21;
                jCContext.free();
            }
            Object var26_26 = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
                EndianOutputStream endianOutputStream = new EndianOutputStream((OutputStream)byteArrayOutputStream);
                endianOutputStream.writeLoHiInt(this.result);
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                String string = throwable.getLocalizedMessage() + "(3)";
                StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
                byArray = null;
            }
            break block22;
            {
                catch (DSErr dSErr) {
                    this.result = dSErr.getCode();
                    Object var26_27 = null;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
                        EndianOutputStream endianOutputStream = new EndianOutputStream((OutputStream)byteArrayOutputStream);
                        endianOutputStream.writeLoHiInt(this.result);
                        byteArrayOutputStream.close();
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    catch (Throwable throwable) {
                        String string = throwable.getLocalizedMessage() + "(3)";
                        StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
                        byArray = null;
                    }
                    break block22;
                }
                catch (Throwable throwable) {
                    String string = throwable.getLocalizedMessage() + "(2)";
                    this.result = 9140;
                    StatusLog.logError(this.result, this.getSubVerbName(), string);
                    Object var26_28 = null;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
                        EndianOutputStream endianOutputStream = new EndianOutputStream((OutputStream)byteArrayOutputStream);
                        endianOutputStream.writeLoHiInt(this.result);
                        byteArrayOutputStream.close();
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    catch (Throwable throwable2) {
                        String string4 = throwable2.getLocalizedMessage() + "(3)";
                        StatusLog.logError(9140, this.getSubVerbName(), throwable2.getLocalizedMessage());
                        byArray = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var26_29 = null;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
                    EndianOutputStream endianOutputStream = new EndianOutputStream((OutputStream)byteArrayOutputStream);
                    endianOutputStream.writeLoHiInt(this.result);
                    byteArrayOutputStream.close();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable3) {
                    String string = throwable3.getLocalizedMessage() + "(3)";
                    StatusLog.logError(9140, this.getSubVerbName(), throwable3.getLocalizedMessage());
                    Object var7_48 = null;
                }
                throw throwable;
            }
        }
        return byArray;
    }

    public String getSubVerbName() {
        return "DSVR_CHECK_OBJECT_PASSWORD";
    }

    protected JCValue[] getAssociations(JCContext jCContext, String string, Entry entry) throws VRDException {
        try {
            JCValue[] jCValueArray;
            JCReadFilter jCReadFilter = new JCReadFilter(false, new JCTimestamp(), new String[]{"DirXML-Associations"});
            entry.goTo(jCContext);
            JCValue[] jCValueArray2 = null;
            try {
                jCValueArray2 = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
            }
            catch (JCException jCException) {
                if (jCException.getErrorCode() != -602 && jCException.getErrorCode() != -603) {
                    throw jCException;
                }
                return null;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < jCValueArray2.length) {
                jCValueArray = (JCValue[])jCValueArray2[n2];
                String string2 = jCContext.standardizeDN(jCValueArray.getVolumeDN(), null);
                if (string2.equalsIgnoreCase(string)) {
                    jCValueArray2[n++] = jCValueArray;
                }
                ++n2;
            }
            if (n == 0) {
                return null;
            }
            if (n != jCValueArray2.length) {
                jCValueArray = new JCValue[n];
                System.arraycopy(jCValueArray2, 0, jCValueArray, 0, n);
                jCValueArray2 = jCValueArray;
            }
            return jCValueArray2;
        }
        catch (JCException jCException) {
            throw new VRDException(jCException);
        }
    }
}

