/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.background.Scheduler;
import com.novell.nds.dirxml.engine.background.Task;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ChunkyResults {
    private static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.verb.ChunkyResults");
    private static final String TASK_RUN_MSG = "cr_taskmsg";
    private static final String DELETE_RESULT_MSG = "cr_remres";
    private Map results = new HashMap();
    private TimeoutTask task = null;

    ChunkyResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int registerResult(byte[] byArray, int n, long l, long l2) {
        Result result = new Result(byArray, n, l, l2);
        Map map = this.results;
        synchronized (map) {
            this.results.put(new Integer(result.hashCode()), result);
            if (this.task == null) {
                this.task = new TimeoutTask();
                Scheduler.schedule(this.task, 30);
            }
        }
        return result.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getResultEntryID(int n) throws DSErr {
        Result result;
        Map map = this.results;
        synchronized (map) {
            result = (Result)this.results.get(new Integer(n));
        }
        if (result == null) {
            throw new DSErr(-322);
        }
        return result.getEntryID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getResultRightsBits(int n) throws DSErr {
        Result result;
        Map map = this.results;
        synchronized (map) {
            result = (Result)this.results.get(new Integer(n));
        }
        if (result == null) {
            throw new DSErr(-322);
        }
        return result.getRightsBits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discardResult(int n) {
        Map map = this.results;
        synchronized (map) {
            this.results.remove(new Integer(n));
            if (this.results.size() == 0 && this.task != null) {
                Scheduler.cancel(this.task);
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResultChunk(int n, int n2, int n3) throws DSErr {
        Result result;
        Map map = this.results;
        synchronized (map) {
            result = (Result)this.results.get(new Integer(n));
        }
        if (result == null) {
            throw new DSErr(-322);
        }
        try {
            int n4;
            result.adjustExpiration(n3);
            int n5 = result.getData().length - result.getOffset();
            int n6 = n4 = n5 < n2 ? n5 : n2;
            if (n4 == 0) {
                return null;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(result.getData(), result.getOffset(), byArray, 0, n4);
            result.updateOffset(n4);
            return byArray;
        }
        catch (Throwable throwable) {
            throw new DSErr(-641);
        }
    }

    private class TimeoutTask
    extends Task {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EngineTrace.staticTracer.trace(4, ChunkyResults.TASK_RUN_MSG, (MessageSource)messageSource);
            long l = new Date().getTime();
            Map map = ChunkyResults.this.results;
            synchronized (map) {
                Iterator iterator = ChunkyResults.this.results.values().iterator();
                while (iterator.hasNext()) {
                    Result result = (Result)iterator.next();
                    if (result.getExpiration() >= l) continue;
                    iterator.remove();
                    EngineTrace.staticTracer.trace(4, ChunkyResults.DELETE_RESULT_MSG, (MessageSource)messageSource, (Object)new Integer(result.hashCode()));
                    result = null;
                }
                if (ChunkyResults.this.results.size() == 0) {
                    Scheduler.cancel(this);
                    ChunkyResults.this.task = null;
                }
            }
        }

        public String getTaskName() {
            return "Timeout for stored DirXML verb results";
        }
    }

    private static class Result {
        private byte[] data;
        private int offset;
        private long expiration;
        private long entryID;
        private long rightsBits;

        Result(byte[] byArray, int n, long l, long l2) {
            this.data = byArray;
            this.entryID = l;
            this.rightsBits = l2;
            this.offset = 0;
            this.expiration = new Date().getTime() + (long)(n * 60 * 1000);
        }

        byte[] getData() {
            return this.data;
        }

        int getOffset() {
            return this.offset;
        }

        void updateOffset(int n) {
            this.offset += n;
            if (this.data != null && this.offset >= this.data.length) {
                this.data = null;
            }
        }

        long getExpiration() {
            return this.expiration;
        }

        void adjustExpiration(int n) {
            this.expiration += (long)(n * 60 * 1000);
        }

        long getEntryID() {
            return this.entryID;
        }

        long getRightsBits() {
            return this.rightsBits;
        }
    }
}

