/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;

class BooleanConstraint
extends Constraint {
    public static final BooleanConstraint BOOLEAN;
    private static final ConstraintGroup TRUE;
    private static final ConstraintGroup FALSE;
    private Constraint trueConstraint = TRUE;
    private Constraint falseConstraint = FALSE;

    Boolean parse(Parameter param, String someValue) {
        if (someValue == null) {
            return null;
        }
        if (this.isTrue(param, someValue)) {
            return Boolean.TRUE;
        }
        if (this.isFalse(param, someValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    boolean isTrue(Parameter param, String someValue) {
        return this.trueConstraint.isValid(param, someValue);
    }

    boolean isFalse(Parameter param, String someValue) {
        return this.falseConstraint.isValid(param, someValue);
    }

    boolean isValid(Parameter param, String someValue) {
        return this.isTrue(param, someValue) || this.isFalse(param, someValue);
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.trueConstraint.getLegalValues());
        buffer.append(", ");
        buffer.append(this.falseConstraint.getLegalValues());
        return buffer.toString();
    }

    static {
        ConstraintGroup group = new ConstraintGroup();
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"y", "yes", "t", "true", "on"});
        group.add(enumConstraint);
        RangeConstraint range = new RangeConstraint(1L, 1L);
        group.add(range);
        group.setConstant();
        TRUE = group;
        group = new ConstraintGroup();
        enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"n", "no", "f", "false", "off"});
        group.add(enumConstraint);
        range = new RangeConstraint(1L, 1L);
        range.setNOT();
        group.add(range);
        group.setConstant();
        FALSE = group;
        BooleanConstraint constraint = new BooleanConstraint();
        constraint.setConstant();
        BOOLEAN = constraint;
    }
}

