/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collections;
import java.util.List;

public abstract class Constraint {
    protected static final String OPEN_SET = "[";
    protected static final String CLOSE_SET = "]";
    protected static final String KEYWORD_AND = "and";
    protected static final String KEYWORD_OR = "or";
    protected static final String KEYWORD_NOT = "not";
    private static final boolean DEFAULT_CONSTANT = false;
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONTAINER = false;
    private static final boolean DEFAULT_NOT = false;
    protected boolean constant;
    protected boolean required;
    protected boolean container;
    protected boolean not;
    protected List constraints;

    private void init() {
        this.constant = false;
        this.required = false;
        this.constraints = Collections.EMPTY_LIST;
        this.container = false;
        this.not = false;
    }

    protected Constraint() {
        this.init();
    }

    abstract String getLegalValues();

    protected void checkConstant() {
        if (this.constant) {
            throw new IllegalStateException("Constraint is unmodifiable.");
        }
    }

    boolean isContainer() {
        return this.container;
    }

    boolean isConstant() {
        return this.constant;
    }

    void setConstant() {
        this.constant = true;
    }

    List getConstraints() {
        return this.constraints;
    }

    abstract boolean isValid(Parameter var1, String var2);

    boolean getNOT() {
        return this.not;
    }

    protected void setRequired() {
        this.required = true;
    }

    boolean isRequired() {
        return this.required;
    }

    public String toString() {
        String string = OPEN_SET + this.getLegalValues() + CLOSE_SET;
        if (this.not) {
            string = KEYWORD_NOT + string;
        }
        return string;
    }
}

