/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ConstraintGroup
extends Constraint {
    private static final LogicalOp DEFAULT_OP = LogicalOp.OR;
    private List constraints;
    private LogicalOp op;

    private void init() {
        this.constraints = new LinkedList();
        this.op = DEFAULT_OP;
    }

    public ConstraintGroup() {
        this.init();
        ((Constraint)this).constraints = new LinkedList();
        this.container = true;
    }

    void setConstant() {
        this.constant = true;
        ListIterator l = this.constraints.listIterator();
        while (l.hasNext()) {
            Constraint c = (Constraint)l.next();
            c.setConstant();
        }
    }

    List getConstraints() {
        return this.constraints;
    }

    public void add(Constraint constraint) {
        Lib.CheckParam(constraint, "constraint");
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        this.constraints.add(constraint);
    }

    LogicalOp getLogicalOp() {
        return this.op;
    }

    public void setOperator(LogicalOp someOp) {
        Lib.CheckParam(someOp, "someOp");
        this.op = someOp;
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    boolean isValid(Parameter param, String someValue) {
        if (this.op == LogicalOp.AND) {
            return this.applyANDGroup(param, someValue);
        }
        if (this.op == LogicalOp.OR) {
            return this.applyORGroup(param, someValue);
        }
        throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
    }

    String getLegalValues() {
        int size = this.constraints.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            Constraint constraint = (Constraint)this.constraints.get(0);
            return constraint.getLegalValues();
        }
        int current = 1;
        StringBuffer buffer = new StringBuffer(32 * size);
        buffer.append("(");
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            buffer.append(constraint.toString());
            if (current < size) {
                buffer.append(" " + this.op.toString() + " ");
            }
            ++current;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private boolean applyANDGroup(Parameter param, String someValue) {
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            if (constraint.isValid(param, someValue)) continue;
            return false;
        }
        return true;
    }

    private boolean applyORGroup(Parameter param, String someValue) {
        Object failed = null;
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint current = (Constraint)c.next();
            if (!current.isValid(param, someValue)) continue;
            return true;
        }
        return false;
    }
}

