/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.XDSDocument;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentImpl
implements XDSDocument {
    protected static final ValidationLevel DEFAULT_WRITE_VALIDATION_LEVEL = ValidationLevel.STRICT;
    protected static final ValidationLevel DEFAULT_READ_VALIDATION_LEVEL = ValidationLevel.PERMISSIVE;
    protected XDSSourceElement source;
    Document document;
    Element ioElement;
    Element rootElement;
    int context;
    String tagName;
    ValidationLevel level;
    DTDVersion version;
    private String versionString;
    boolean validate;
    protected boolean commandContainer;
    private List children;

    private void init() {
        this.children = Collections.EMPTY_LIST;
        this.commandContainer = false;
    }

    DocumentImpl(String someXML) {
        this.init();
        this.setLevel(DEFAULT_READ_VALIDATION_LEVEL);
        this.document = new XmlDocument(someXML).getDocument();
        if (this.document == null) {
            if (this.validate) {
                throw new IllegalArgumentException("Document is either empty or malformed.");
            }
            return;
        }
        this.rootElement = this.document.getDocumentElement();
        this.context = 0;
    }

    DocumentImpl() {
        this.init();
        this.setLevel(DEFAULT_WRITE_VALIDATION_LEVEL);
        this.document = DocumentFactory.newDocument();
        this.context = 1;
    }

    private void setValidate() {
        this.validate = this.level != ValidationLevel.NONE;
    }

    protected DocumentImpl(Document domDocument, String directionTag, int someContext, ValidationLevel someLevel) throws XDSParseException {
        Lib.CheckParam(someLevel, "someLevel");
        this.init();
        this.setLevel(someLevel);
        this.document = domDocument;
        this.tagName = directionTag;
        this.context = someContext;
        this.rootElement = this.parseElement("nds");
        this.ioElement = this.parseElement(directionTag);
        this.parseVersion();
    }

    private void parseVersion() throws XDSParseException {
        this.versionString = Lib.ToNull(this.rootElement.getAttribute("dtdversion"));
        this.version = this.versionString == null ? DTDVersion.UNKNOWN : DTDVersion.Lookup(this.versionString);
    }

    protected DocumentImpl(XmlDocument xdsXML, String directionTag, int someContext, ValidationLevel someLevel) throws XDSParseException {
        Lib.CheckParam(xdsXML, "xdsXML");
        Lib.CheckParam(someLevel, "someLevel");
        this.init();
        this.document = xdsXML.getDocument();
        if (this.document == null) {
            if (this.validate) {
                throw new RuntimeException("Document is either empty or malformed.");
            }
            return;
        }
        this.setLevel(someLevel);
        this.tagName = directionTag;
        this.context = someContext;
        this.rootElement = this.parseElement("nds");
        this.ioElement = this.parseElement(directionTag);
        Element temp = this.parseOptionalElement("source");
        this.source = temp == null ? null : new XDSSourceElement(temp, this);
        this.parseVersion();
    }

    protected boolean LT(DTDVersion someVersion) {
        return this.version.compareTo(someVersion) == -1;
    }

    protected boolean GTE(DTDVersion someVersion) {
        return this.version.compareTo(someVersion) != -1;
    }

    private Element parseOptionalElement(String tag) {
        NodeList nodes = this.document.getElementsByTagName(tag);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    private Element parseElement(String tag) throws XDSParseException {
        NodeList nodes = this.document.getElementsByTagName(tag);
        int noOfNodes = nodes.getLength();
        if (noOfNodes == 0 && this.validate) {
            throw new XDSParseException(Errors.NoElement(tag));
        }
        if (noOfNodes > 1 && this.validate) {
            throw new XDSParseException(Errors.DuplicateElement(tag));
        }
        return (Element)nodes.item(0);
    }

    int getContext() {
        return this.context;
    }

    ValidationLevel getLevel() {
        return this.level;
    }

    public Document domDocument() {
        return this.document;
    }

    DocumentImpl(String directionTag, int someContext, NDSVersion ndsVersion, DTDVersion dtdVersion) {
        Lib.CheckParam(dtdVersion, "dtdVersion");
        this.init();
        this.setLevel(DEFAULT_WRITE_VALIDATION_LEVEL);
        this.document = DocumentFactory.newDocument();
        this.context = someContext;
        this.tagName = directionTag;
        this.version = dtdVersion;
        this.rootElement = this.document.createElement("nds");
        if (this.LT(DTDVersion.V2_0)) {
            this.rootElement.setAttribute("ndsversion", ndsVersion.toString());
        }
        this.rootElement.setAttribute("dtdversion", dtdVersion.toString());
        this.document.appendChild(this.rootElement);
        this.ioElement = this.document.createElement(directionTag);
        this.rootElement.appendChild(this.ioElement);
    }

    public boolean isEmpty() {
        return !this.ioElement.hasChildNodes();
    }

    protected ElementImpl parseChildElement(Element element, String tagName, int position, int noOfElements) throws XDSParseException {
        return null;
    }

    protected void handleUnrecognizedElement(Element someElement, String someTagName, int position, int noOfElements) throws XDSParseException {
        if (this.isStrict()) {
            throw new XDSParseException(Errors.IllegalElement(this.ioElement.getTagName(), someTagName));
        }
        NonXDSElement unrecognized = this.commandContainer ? new NonXDSElement(someElement, this) : new NonXDSElement(someElement, this);
        unrecognized.setPosition(position);
        this.children(noOfElements).add(unrecognized);
    }

    protected void parseChildNodes() throws XDSParseException {
        int elementNo = 1;
        NodeList nodes = this.ioElement.getChildNodes();
        int noOfNodes = nodes.getLength();
        int n = 0;
        while (n < noOfNodes) {
            short nodeType = nodes.item(n).getNodeType();
            if (nodeType == 1) {
                int noOfElements;
                String tagName;
                Element domElement = (Element)nodes.item(n);
                ElementImpl child = this.parseChildElement(domElement, tagName = domElement.getTagName(), elementNo, noOfElements = noOfNodes - n);
                if (child == null) {
                    this.handleUnrecognizedElement(domElement, tagName, elementNo, noOfElements);
                } else {
                    child.setPosition(elementNo);
                    this.children(noOfElements).add(child);
                }
                ++elementNo;
            } else if (this.isStrict()) {
                throw new XDSParseException(Errors.IllegalNode(this.ioElement.getTagName(), DOMUtil.describeNode((Node)nodes.item(n))));
            }
            ++n;
        }
    }

    public Element domNDSElement() {
        return this.rootElement;
    }

    public Element domIOElement() {
        return this.ioElement;
    }

    void setContext(int someContext) {
        this.context = someContext;
    }

    void setLevel(ValidationLevel someLevel) {
        this.level = someLevel;
        this.setValidate();
    }

    void setRootElement(Element someElement) {
        this.rootElement = someElement;
    }

    boolean isStrict() {
        return this.level == ValidationLevel.STRICT;
    }

    protected List children(int noOfElements) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList(noOfElements);
        }
        return this.children;
    }

    protected List childElements() {
        return Lib.GetElements(this, this.children);
    }
}

