/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.NamespaceName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
implements XDSElement {
    private static final int DEFAULT_POSITION = -1;
    private static final boolean DEFAULT_ANY_CONTENT = false;
    DocumentImpl document;
    Element element;
    private List children;
    private int position;
    protected boolean anyContent;

    ElementImpl() {
    }

    protected ElementImpl(Element myElement, DocumentImpl myDocument) {
        Lib.CheckParam(myDocument, "myDocument");
        Lib.CheckParam(myElement, "myElement");
        this.document = myDocument;
        this.element = myElement;
        this.children = Collections.EMPTY_LIST;
        this.position = -1;
        this.anyContent = false;
    }

    public String tagName() {
        return this.element.getTagName();
    }

    public Element domElement() {
        return this.element;
    }

    public Document domDocument() {
        return this.document.domDocument();
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        return null;
    }

    protected void passText(String someText) throws XDSParseException {
        if (this.document.isStrict()) {
            throw new XDSParseException(Errors.IllegalText(this.tagName()));
        }
    }

    void setPosition(int number) {
        this.position = number;
    }

    public int position() {
        return this.position;
    }

    List children() {
        return this.children;
    }

    List children(int noOfElements) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList(noOfElements);
        }
        return this.children;
    }

    protected void handleUnrecognizedElement(Element domElement, String tagName, int position, int noOfElements) throws XDSParseException {
        if (!this.anyContent && this.document.isStrict()) {
            throw new XDSParseException(Errors.IllegalElement(this.tagName(), tagName));
        }
        NonXDSElement element = new NonXDSElement(domElement, this.document);
        element.setPosition(position);
        this.children(noOfElements).add(element);
    }

    protected void parseChildNodes() throws XDSParseException {
        NodeList childNodes = this.element.getChildNodes();
        int noOfChildren = childNodes.getLength();
        int elementNo = 1;
        int noOfNodesProcessed = 0;
        int n = 0;
        while (n < noOfChildren) {
            Text textNode;
            String text;
            short nodeType = childNodes.item(n).getNodeType();
            if (nodeType == 1) {
                int noOfElements;
                String tagName;
                Element elementNode = (Element)childNodes.item(n);
                ElementImpl child = this.parseChildElement(elementNode, tagName = elementNode.getTagName(), elementNo, noOfElements = noOfChildren - noOfNodesProcessed);
                if (child != XDS.IGNORE) {
                    if (child == null) {
                        this.handleUnrecognizedElement(elementNode, tagName, elementNo, noOfElements);
                    } else {
                        child.setPosition(elementNo);
                        this.children(noOfElements).add(child);
                    }
                    ++elementNo;
                }
            } else if (nodeType == 3 && Lib.IsValue(text = (textNode = (Text)childNodes.item(n)).getData())) {
                this.passText(text);
            }
            ++noOfNodesProcessed;
            ++n;
        }
    }

    protected ElementImpl(DocumentImpl myDocument, Element myParentElement, String myTagName) {
        Lib.CheckParam(myDocument, "myDocument");
        Lib.CheckParam(myParentElement, "myParentElement");
        Lib.CheckParam(myTagName, "myTagname");
        this.document = myDocument;
        this.children = Collections.EMPTY_LIST;
        this.position = -1;
        this.anyContent = false;
        this.element = this.document.domDocument().createElement(myTagName);
        myParentElement.appendChild(this.element);
    }

    public String attributeValueGet(String attrName) {
        if (attrName == null) {
            return null;
        }
        return Lib.ToNull(this.element.getAttribute(attrName));
    }

    protected void setAttributeValue(String name, Object value, DTDVersion requiredVersion) {
        Lib.CheckContext(this.document.context, 1);
        Lib.CheckParam(requiredVersion, "requiredVersion");
        Lib.CheckVersion(this.document.version, requiredVersion);
        if (name == null || value == null) {
            return;
        }
        this.element.setAttribute(name, value.toString());
    }

    protected void setAttributeValue(String name, String value, DTDVersion requiredVersion) {
        Lib.CheckContext(this.document.context, 1);
        Lib.CheckParam(requiredVersion, "requiredVersion");
        Lib.CheckVersion(this.document.version, requiredVersion);
        if (name == null || Lib.NoValue(value)) {
            return;
        }
        this.element.setAttribute(name, value);
    }

    public void attributeValueSet(String name, String value) {
        Lib.CheckContext(this.document.context, 1);
        if (name == null || Lib.NoValue(value)) {
            return;
        }
        this.element.setAttribute(name, value);
    }

    protected void setAttributeValue(String name, Object value) {
        Lib.CheckContext(this.document.context, 1);
        if (name == null || value == null) {
            return;
        }
        this.element.setAttribute(name, value.toString());
    }

    public String localName() {
        return DOMUtil.getLocalName((Node)this.element);
    }

    public String namespaceName() {
        return DOMUtil.getNamespaceName((Node)this.element).getString();
    }

    public String attributeValueGet(String someNamespaceName, String someAttrName) {
        if (someAttrName == null) {
            return null;
        }
        if (someNamespaceName == null) {
            return this.attributeValueGet(someAttrName);
        }
        NamedNodeMap attributes = this.element.getAttributes();
        int noOfAttributes = attributes.getLength();
        int a = 0;
        while (a < noOfAttributes) {
            String namespace;
            NamespaceName namespaceName;
            Attr attribute = (Attr)attributes.item(a);
            String localName = DOMUtil.getLocalName((Node)attribute);
            if (localName.equals(someAttrName) && (namespaceName = DOMUtil.getNamespaceName((Node)attribute)) != null && !namespaceName.isEmpty() && someNamespaceName.equals(namespace = namespaceName.getString())) {
                return Lib.ToNull(attribute.getNodeValue());
            }
            ++a;
        }
        return null;
    }

    protected void throwMissingAttributeException(String attrName) throws XDSParseException {
        Attr attr = this.element.getAttributeNode(attrName);
        if (attr == null) {
            throw new XDSParseException(Errors.NoAttribute(attrName));
        }
        throw new XDSParseException(Errors.NoAttributeValue(attrName));
    }

    public List childElements() {
        return Lib.GetElements(this, this.children);
    }

    protected void doNotCall(int expected) {
        throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(expected)));
    }
}

