/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.CaseInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.CaseSensitiveComparator;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EnumConstraint
extends Constraint {
    public static final Comparator CASE_SENSITIVE = new CaseSensitiveComparator();
    public static final Comparator CASE_INSENSITIVE;
    private static final Comparator DEFAULT_COMP;
    private static final boolean DEFAULT_NOT = false;
    private List enum;
    private Comparator comparator;

    public EnumConstraint() {
        this.not = false;
        this.setComparator(DEFAULT_COMP);
        this.setEnum();
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEnum() {
        this.enum = new LinkedList();
    }

    public void setComparator(Comparator someComparator) {
        Lib.CheckParam(someComparator, "someComparator");
        this.comparator = someComparator;
    }

    public void addLiteral(String value) {
        this.checkConstant();
        Lib.CheckParam(value, "value");
        this.enum.add(value);
    }

    public void addLiterals(String[] someValues) {
        this.checkConstant();
        Lib.CheckParam(someValues, "someValues");
        int v = 0;
        while (v < someValues.length) {
            String value = someValues[v];
            if (value != null) {
                this.enum.add(value);
            }
            ++v;
        }
    }

    boolean isValid(Parameter param, String someValue) {
        return someValue == null ? true : this.isValid(someValue, this.not);
    }

    private boolean isValid(String someValue, boolean returnVal) {
        ListIterator l = this.enum.listIterator();
        while (l.hasNext()) {
            if (this.comparator.compare((String)l.next(), someValue) != 0) continue;
            return !returnVal;
        }
        return returnVal;
    }

    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(48);
        if (this.not) {
            buffer.append("not");
        }
        boolean first = true;
        ListIterator l = this.enum.listIterator();
        while (l.hasNext()) {
            String value = (String)l.next();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append("'" + value + "'");
        }
        return buffer.toString();
    }

    static {
        DEFAULT_COMP = CASE_INSENSITIVE = new CaseInsensitiveComparator();
    }
}

