/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Lib {
    Lib() {
    }

    static int NormalizeCompare(int value) {
        if (value < 0) {
            return -1;
        }
        if (value > 0) {
            return 1;
        }
        return 0;
    }

    static ElementImpl OptionsElement_parseChildElement(ElementImpl parent, Element childElement, String tagName, int position, int noOfElements, List[] params, List[] instances) throws XDSParseException {
        ElementImpl child = null;
        if ("instance".compareTo(tagName) == 0) {
            if (instances[0] == Collections.EMPTY_LIST) {
                instances[0] = new LinkedList();
            }
            child = new XDSInstanceElement(childElement, parent.document);
            instances[0].add(child);
        } else {
            if (params[0] == Collections.EMPTY_LIST) {
                params[0] = new ArrayList(noOfElements);
            }
            child = new NonXDSElement(childElement, parent.document);
            params[0].add(child);
        }
        return child;
    }

    static void ExtractParams(Map paramElements, Map params) throws XDSParameterException {
        Lib.CheckParam(paramElements, "paramElements");
        Lib.CheckParam(params, "params");
        XDSParameterException first = null;
        XDSParameterException last = null;
        XDSParameterException current = null;
        Iterator entries = params.values().iterator();
        while (entries.hasNext()) {
            Parameter param = (Parameter)entries.next();
            ParamElement paramElement = (ParamElement)paramElements.get(param.tagName());
            if (paramElement == null) {
                if (!param.isRequired()) continue;
                current = new XDSParameterException(Errors.NoParam(param.tagName()));
                if (last == null) {
                    first = current;
                    last = current;
                    continue;
                }
                last.setNext(current);
                last = current;
                continue;
            }
            param.setParamElement(paramElement);
            String description = paramElement.attributeValueGet("display-name");
            if (description == null) {
                description = param.getDescription();
            } else {
                param.setDescription(description);
            }
            try {
                param.setValue(paramElement.extractText());
            }
            catch (XDSParameterException p) {
                if (last == null) {
                    first = p;
                    last = p;
                    continue;
                }
                last.setNext(p);
                last = p;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    static ElementImpl StateElement_parseChildElement(ElementImpl parent, Element childElement, String tagName, int position, int noOfElements, List[] params) throws XDSParseException {
        NonXDSElement param = new NonXDSElement(childElement, parent.document);
        if (params[0] == Collections.EMPTY_LIST) {
            params[0] = new ArrayList(noOfElements);
        }
        params[0].add(param);
        return param;
    }

    static void ParamParent_populateMap(ElementImpl parent, Map[] map, List params) throws XDSParameterException {
        if (map[0] == XDS.EMPTY_MAP && params.size() > 0) {
            map[0] = new HashMap(params.size());
            ListIterator p = params.listIterator();
            while (p.hasNext()) {
                ParamElement param = (ParamElement)p.next();
                ParamElement o = map[0].put(param.tagName(), param);
                if (o == null) continue;
                throw new XDSParameterException(Errors.DuplicateParam(parent.tagName(), param.tagName()));
            }
        }
    }

    static ParamElement ParamParent_paramElement(ElementImpl impl, Map map, String tagName) {
        Lib.CheckContext(impl.document.context, 0);
        return (ParamElement)map.get(tagName);
    }

    static String ParamParent_paramText(ElementImpl impl, Map map, String tagName) {
        Lib.CheckContext(impl.document.context, 0);
        ParamElement element = (ParamElement)map.get(tagName);
        return element == null ? null : element.extractText();
    }

    static String GetText(ElementImpl impl, TextParent parent) {
        Lib.CheckContext(impl.document.context, 0);
        if (parent == null) {
            return null;
        }
        return parent.extractText();
    }

    static boolean GetValue(ElementImpl impl, _Boolean bool) {
        Lib.CheckContext(impl.document.context, 0);
        if (bool == null) {
            return false;
        }
        return bool.toPrimitive();
    }

    static String GetValue(ElementImpl impl, String value) {
        Lib.CheckContext(impl.document.context, 0);
        return value;
    }

    static String GetAttributeValue(ElementImpl impl, String attrName) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet(attrName);
    }

    static void CheckParam(String param, String paramName) {
        if (param == null || "".compareTo(param) == 0) {
            throw new IllegalArgumentException(Errors.NoParamValue(paramName));
        }
    }

    static _Boolean ToBoolean(String strValue, _Boolean defaultValue) {
        if (strValue == null) {
            return defaultValue;
        }
        if (strValue.compareTo("true") == 0) {
            return _Boolean.TRUE;
        }
        if (strValue.compareTo("false") == 0) {
            return _Boolean.FALSE;
        }
        return new _Boolean(strValue);
    }

    public static String ToNull(String someValue) {
        if (Lib.NoValue(someValue)) {
            return null;
        }
        return someValue;
    }

    static boolean IsValue(String someValue) {
        return someValue != null && "".compareTo(someValue) != 0;
    }

    static boolean NoValue(String someValue) {
        return someValue == null || "".compareTo(someValue) == 0;
    }

    static void CheckParam(Object obj, String paramName) {
        if (obj == null) {
            throw new IllegalArgumentException(Errors.NoParamValue(paramName));
        }
    }

    static void AssociationElementParent_validate(ElementImpl parent, XDSAssociationElement association, int noOfAssociations, boolean required) throws XDSParseException {
        if (association != null) {
            if (noOfAssociations > 1) {
                throw new XDSParseException(Errors.DuplicateElement("association"));
            }
            if (parent.document.isStrict() && association.position() != 1) {
                throw new XDSParseException(Errors.MisplacedElement(parent.tagName(), "association", 1));
            }
        }
    }

    static XDSAssociationElement AssociationElementParent_appendAssociationElement(ElementImpl impl, String value) {
        Lib.CheckParam(impl, "impl");
        Lib.CheckParam(impl.document, "impl.document");
        Lib.CheckParam(impl.element, "impl.element");
        Lib.CheckContext(impl.document.context, 1);
        XDSAssociationElement association = new XDSAssociationElement(impl.document, impl.element);
        association.appendText(value);
        return association;
    }

    static XDSAssociationElement AssociationElementParent_associationElement(ElementImpl impl, XDSAssociationElement association) {
        Lib.CheckContext(impl.document.context, 0);
        return association;
    }

    static String AssociationElementParent_associationText(ElementImpl impl, XDSAssociationElement association) {
        Lib.CheckContext(impl.document.context, 0);
        if (association == null) {
            return null;
        }
        return association.extractText();
    }

    static void CheckVersion(DTDVersion actual, DTDVersion expected) {
        if (actual.compareTo(expected) == -1) {
            throw new XDSMethodInvocationContextException(Errors.WrongDTDVersion(expected.toString()));
        }
    }

    static void CheckContext(int actual, int expected) {
        if (actual != expected) {
            throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(expected)));
        }
    }

    static List GetElements(DocumentImpl impl, List elements) {
        Lib.CheckParam(impl, "impl");
        Lib.CheckParam(elements, "elements");
        Lib.CheckContext(impl.context, 0);
        return elements;
    }

    static List GetElements(ElementImpl impl, List elements) {
        Lib.CheckContext(impl.document.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return elements;
    }

    static List ValueElementParent_extractValueElements(ElementImpl impl, List[] elements) {
        Lib.CheckContext(impl.document.context, 0);
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        return elements[0];
    }

    static XDSValueElement ValueElementParent_appendValueElement(ElementImpl impl, ValueType type, String text) {
        Lib.CheckParam(impl, "impl");
        Lib.CheckContext(impl.document.context, 1);
        XDSValueElement value = new XDSValueElement(impl.document, impl.element, type);
        if (text != null) {
            value.appendText(text);
        }
        return value;
    }

    static ElementImpl ValueElementParent_parseChildElement(ElementImpl parent, Element childElement, String tagName, int noOfElements, List[] values) throws XDSParseException {
        XDSValueElement child = null;
        if ("value".compareTo(tagName) == 0) {
            child = new XDSValueElement(childElement, parent.document);
            if (values[0] == Collections.EMPTY_LIST) {
                values[0] = new ArrayList(noOfElements);
            }
            values[0].add(child);
        }
        return child;
    }

    static void ValueElementsParent_validate(ElementImpl impl) throws XDSParseException {
        if (impl.children() == Collections.EMPTY_LIST) {
            throw new XDSParseException(Errors.NoElement("value"));
        }
    }

    static void TextParent_appendText(ElementImpl impl, String pcdata) {
        Lib.CheckContext(impl.document.context, 1);
        if (Lib.NoValue(pcdata)) {
            return;
        }
        Text text = impl.document.document.createTextNode(pcdata);
        impl.element.appendChild(text);
    }

    static String TextParent_text(ElementImpl impl, String text) {
        Lib.CheckContext(impl.document.context, 0);
        return Lib.ToNull(text);
    }

    static String SomeAttrElement_getAttrName(ElementImpl impl, String attrName) {
        Lib.CheckContext(impl.document.context, 0);
        return attrName;
    }

    static void SomeAttrElement_setAttrName(ElementImpl impl, String value) {
        Lib.CheckContext(impl.document.context, 1);
        impl.attributeValueSet("attr-name", value);
    }

    static void SomeAttrElement_validate(ElementImpl impl, String attrName) throws XDSParseException {
        if (attrName == null) {
            impl.throwMissingAttributeException("attr-name");
        }
    }

    static XmlDocument WriteableDocument_toXML(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XmlDocument(impl.document);
    }

    static XDSModifyAssociationElement WriteableDocument_appendModifyAssociationElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSModifyAssociationElement(impl, impl.ioElement);
    }

    static XDSInitParamsElement StateDocument_appendInitParamsElement(DocumentImpl impl, XDSInitParamsElement[] initParams) {
        Lib.CheckContext(impl.context, 1);
        if (initParams[0] == null) {
            initParams[0] = new XDSInitParamsElement(impl, impl.ioElement);
        }
        return initParams[0];
    }

    static XDSSourceElement WriteableDocument_appendSourceElement(DocumentImpl impl, XDSSourceElement source) {
        Lib.CheckContext(impl.context, 1);
        if (source == null) {
            source = new XDSSourceElement(impl, impl.rootElement);
            Element element = source.domElement();
            impl.rootElement.removeChild(element);
            impl.rootElement.insertBefore(element, impl.ioElement);
        }
        return source;
    }

    static XDSStatusElement StatusDocument_appendHeartbeat(DocumentImpl impl) {
        XDSStatusElement status = Lib.StatusDocument_appendStatusElement(impl);
        status.setLevel(StatusLevel.SUCCESS);
        status.setType(StatusType.HEARTBEAT);
        return status;
    }

    static XDSStatusElement StatusDocument_appendStatusElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSStatusElement(impl, impl.ioElement);
    }

    static void WriteableDocument_setEmpty(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        Element newElement = impl.document.createElement(impl.tagName);
        impl.rootElement.replaceChild(newElement, impl.ioElement);
        impl.ioElement = newElement;
    }

    static void CommandElement_setEventID(ElementImpl impl, String someID) {
        impl.attributeValueSet("event-id", someID);
    }

    static String CommandElement_getEventID(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("event-id");
    }

    static String CommandElement_getSrcDN(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("src-dn");
    }

    static String CommandElement_getQualifiedSrcDN(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("qualified-src-dn");
    }

    static String CommandElement_getSrcEntryID(ElementImpl impl) {
        Lib.CheckContext(impl.document.context, 0);
        return impl.attributeValueGet("src-entry-id");
    }

    static XDSPasswordElement PasswordElementParent_passwordElement(ElementImpl impl, XDSPasswordElement password) {
        Lib.CheckContext(impl.document.context, 0);
        return password;
    }

    static String PasswordElementParent_passwordText(ElementImpl impl, XDSPasswordElement password) {
        return Lib.GetText(impl, password);
    }

    static DTDVersion ReadableDocument_dtdVersion(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 0);
        return impl.version;
    }

    static XDSSourceElement ReadableDocument_sourceElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 0);
        return impl.source;
    }

    static void QueryResultDocument_Sort(Map map) {
        Iterator status = map.values().iterator();
        while (status.hasNext()) {
            List levels = (List)status.next();
            Collections.sort(levels);
        }
    }

    static void QueryResultDocument_PopulateMap(Map[] map, List elements) {
        if (map[0] == XDS.EMPTY_MAP) {
            map[0] = new HashMap(elements.size());
            ListIterator l = elements.listIterator();
            while (l.hasNext()) {
                XDSStatusElement status = (XDSStatusElement)l.next();
                String eventID = status.getEventID();
                if (eventID == null) continue;
                LinkedList<XDSStatusElement> levels = (LinkedList<XDSStatusElement>)map[0].get(eventID);
                if (levels == null) {
                    levels = new LinkedList<XDSStatusElement>();
                    levels.add(status);
                    map[0].put(eventID, levels);
                    continue;
                }
                levels.add(status);
            }
            Lib.QueryResultDocument_Sort(map[0]);
        }
    }

    public static StatusLevel ResultDocument_mostSevereStatusLevel(String id, Map[] map, List list, XDSStatusElement mostSevere) {
        XDSStatusElement element = Lib.ResultDocument_mostSevereStatusElement(id, map, list, mostSevere);
        return element == null ? StatusLevel.SUCCESS : element.getLevel();
    }

    static XDSStatusElement ResultDocument_mostSevereStatusElement(String id, Map[] map, List list, XDSStatusElement mostSevere) {
        Lib.QueryResultDocument_PopulateMap(map, list);
        List levels = (List)map[0].get(id);
        if (levels != null && !levels.isEmpty()) {
            return (XDSStatusElement)levels.get(0);
        }
        return mostSevere;
    }

    static List QueryResultDocument_extractStatusElements(Map[] map, List list, String someID) {
        Lib.QueryResultDocument_PopulateMap(map, list);
        list = (List)map[0].get(someID);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    static ElementImpl QueryResultDocument_parseChildElement(DocumentImpl doc, Element domElement, String tagName, int position, int noOfElements, List[] statusElements, List[] instanceElements, XDSStatusElement[] mostSevere) throws XDSParseException {
        ElementImpl child = null;
        if ("status".compareTo(tagName) == 0) {
            child = new XDSStatusElement(domElement, doc);
            if (mostSevere[0] == null) {
                mostSevere[0] = child;
            } else {
                ElementImpl elementImpl = mostSevere[0] = mostSevere[0].compareTo(child) == 1 ? child : mostSevere[0];
            }
            if (statusElements[0] == Collections.EMPTY_LIST) {
                statusElements[0] = new LinkedList();
            }
            statusElements[0].add(child);
        } else if ("instance".compareTo(tagName) == 0) {
            if (instanceElements[0] == Collections.EMPTY_LIST) {
                instanceElements[0] = new LinkedList();
            }
            child = new XDSInstanceElement(domElement, doc);
            instanceElements[0].add(child);
        }
        return child;
    }

    static Node CloneSubtree(Document targetDoc, Node sourceRoot) {
        try {
            switch (sourceRoot.getNodeType()) {
                case 1: {
                    Element sourceElement = (Element)sourceRoot;
                    Element clonedElement = targetDoc.createElement(sourceElement.getNodeName());
                    NamedNodeMap attributes = sourceElement.getAttributes();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Attr attr = (Attr)attributes.item(i);
                        clonedElement.setAttribute(attr.getName(), attr.getValue());
                        ++i;
                    }
                    NodeList children = sourceElement.getChildNodes();
                    int i2 = 0;
                    while (i2 < children.getLength()) {
                        clonedElement.appendChild(Lib.CloneSubtree(targetDoc, children.item(i2)));
                        ++i2;
                    }
                    return clonedElement;
                }
                case 2: {
                    Attr clonedAttr = targetDoc.createAttribute(((Attr)sourceRoot).getName());
                    clonedAttr.setValue(((Attr)sourceRoot).getValue());
                    return clonedAttr;
                }
                case 3: {
                    return targetDoc.createTextNode(((Text)sourceRoot).getData());
                }
                case 4: {
                    return targetDoc.createCDATASection(((CDATASection)sourceRoot).getData());
                }
                case 5: {
                    return targetDoc.createEntityReference(sourceRoot.getNodeName());
                }
                case 7: {
                    return targetDoc.createProcessingInstruction(sourceRoot.getNodeName(), sourceRoot.getNodeValue());
                }
                case 8: {
                    return targetDoc.createComment(sourceRoot.getNodeValue());
                }
                case 11: {
                    DocumentFragment clonedFragment = targetDoc.createDocumentFragment();
                    NodeList children = sourceRoot.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        clonedFragment.appendChild(Lib.CloneSubtree(targetDoc, children.item(i)));
                        ++i;
                    }
                    return clonedFragment;
                }
            }
        }
        catch (DOMException de) {}
        return null;
    }

    static XDSInstanceElement QueryResultDocument_appendInstanceElement(DocumentImpl impl) {
        Lib.CheckContext(impl.context, 1);
        return new XDSInstanceElement(impl, impl.ioElement);
    }
}

