/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.BooleanConstraint;
import com.novell.nds.dirxml.driver.xds.CharConstraint;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.IntConstraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.LongConstraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Parameter
implements Comparable {
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONSTANT = false;
    private static final LongConstraint LONG = new LongConstraint();
    private static final IntConstraint INT = new IntConstraint();
    private static final LogicalOp OP = LogicalOp.AND;
    private String tagName;
    private String description;
    private DataType type;
    private Object value;
    private List constraints;
    private ParamElement param;
    private boolean contentSensitive;
    private boolean required;
    private boolean constant;
    private BooleanConstraint bool;
    private HashMap constraintMap;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$RangeConstraint;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$EnumConstraint;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$BooleanConstraint;

    private void init() {
        this.param = null;
        this.bool = null;
        this.constraints = new LinkedList();
        this.required = false;
        this.constant = false;
        this.constraintMap = new HashMap();
        this.description = null;
    }

    public Parameter(String someTagName, String defaultValue, DataType someType) {
        Lib.CheckParam(someTagName, "someTagName");
        Lib.CheckParam(someType, "someType");
        this.init();
        this.tagName = someTagName;
        this.description = someTagName;
        this.setSensitive();
        this.setType(someType);
        this.setDefault(defaultValue);
    }

    private void setSensitive() {
        this.contentSensitive = "password".compareTo(this.tagName) == 0;
    }

    public void setContentSensitive() {
        this.contentSensitive = true;
    }

    public boolean isContentSensitive() {
        return this.contentSensitive;
    }

    private void checkConstraints(Constraint constraint) {
        if (constraint.isContainer()) {
            ListIterator c = constraint.getConstraints().listIterator();
            while (c.hasNext()) {
                this.checkConstraints((Constraint)c.next());
            }
            this.constraintMap.put(constraint.toString(), constraint);
        } else {
            this.checkConstraint(constraint);
            this.constraintMap.put(constraint.toString(), constraint);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkConstraint(Constraint someConstraint) {
        if (this.constraintMap.get(someConstraint.toString()) != null) {
            throw new IllegalArgumentException("Duplicate constraint.  The same constraint may only be applied to the same parameter once.");
        }
        if (someConstraint.getClass() == (class$com$novell$nds$dirxml$driver$xds$RangeConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$RangeConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.RangeConstraint")) : class$com$novell$nds$dirxml$driver$xds$RangeConstraint)) {
            if (DataType.IsRangeType(this.type)) return;
            throw new IllegalArgumentException("Range constraints can only be applied to types 'int', 'long', and 'char'.");
        }
        if (someConstraint.getClass() == (class$com$novell$nds$dirxml$driver$xds$EnumConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$EnumConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.EnumConstraint")) : class$com$novell$nds$dirxml$driver$xds$EnumConstraint)) {
            if (DataType.IsEnumerativeType(this.type)) return;
            throw new IllegalArgumentException("Cannot apply enumerative constraint to type 'boolean'.");
        }
        if (someConstraint.getClass() != (class$com$novell$nds$dirxml$driver$xds$BooleanConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$BooleanConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.BooleanConstraint")) : class$com$novell$nds$dirxml$driver$xds$BooleanConstraint)) return;
        if (!DataType.IsBooleanType(this.type)) throw new IllegalArgumentException("Boolean constraints can only be applied to type 'boolean'.");
        if (this.bool != null) throw new IllegalArgumentException("An parameter can have at most one boolean constraint.");
        this.bool = (BooleanConstraint)someConstraint;
    }

    public void add(Constraint someConstraint) {
        if (this.constant) {
            throw new IllegalStateException("Parameter is read-only.");
        }
        Lib.CheckParam(someConstraint, "someConstraint");
        this.checkConstraint(someConstraint);
        if (someConstraint.isRequired()) {
            this.setRequired();
        }
        someConstraint.setConstant();
        this.constraints.add(someConstraint);
    }

    private void setRequired() {
        this.required = true;
    }

    private void setDefault(String someValue) {
        if (someValue == null) {
            this.value = null;
        } else {
            this.value = this.applyTypeConstraints(someValue);
            if (this.value == null) {
                throw new IllegalArgumentException("Type mismatch.  Default value '" + someValue + "' of parameter '" + this.description + "' is not " + this.type.toClause());
            }
        }
    }

    void setType(DataType someType) {
        this.type = someType;
    }

    public ParamElement paramElement() {
        return this.param;
    }

    DataType getDataType() {
        return this.type;
    }

    public String tagName() {
        return this.tagName;
    }

    void setDescription(String someDescription) {
        Lib.CheckParam(someDescription, "someDescription");
        this.description = someDescription;
    }

    String getDescription() {
        return this.description;
    }

    void setParamElement(ParamElement someElement) {
        this.param = someElement;
    }

    public void overrideValue(String someValue) {
        this.setDefault(someValue);
    }

    void setValue(String someValue) throws XDSParameterException {
        this.constant = true;
        if (someValue != null) {
            Object typedValue = this.applyTypeConstraints(someValue);
            if (typedValue == null) {
                String message = "Type mismatch.  Value '" + someValue + "' of parameter '" + this.description + "' is not " + this.type.toClause() + ".";
                if (this.type == DataType.INT) {
                    message = message + "  Legal values are " + IntConstraint.INT.toString() + ".";
                } else if (this.type == DataType.LONG) {
                    message = message + "  Legal values are " + LongConstraint.LONG.toString() + ".";
                } else if (this.type == DataType.BOOLEAN) {
                    message = message + "  Legal values are " + BooleanConstraint.BOOLEAN.toString() + ".";
                }
                throw new XDSParameterException(message, this);
            }
            this.value = typedValue;
        }
        this.applyOtherConstraints(someValue);
    }

    private void applyOtherConstraints(String someValue) throws XDSParameterException {
        if (!this.constraints.isEmpty()) {
            boolean success = true;
            ListIterator c = this.constraints.listIterator();
            while (c.hasNext()) {
                Constraint constraint = (Constraint)c.next();
                if (constraint.isValid(this, someValue)) continue;
                success = false;
                break;
            }
            if (!success) {
                this.throwParameterException(someValue);
            }
        }
    }

    private void throwParameterException(String someValue) throws XDSParameterException {
        boolean enclose;
        int size = this.constraints.size();
        StringBuffer buffer = new StringBuffer(32 * size);
        buffer.append("Parameter '" + this.description);
        buffer.append("' has illegal value '" + someValue + "'.");
        buffer.append("  Legal values are ");
        boolean bl = enclose = size > 1 || size == 1 && ((Constraint)this.constraints.get(0)).isContainer();
        if (enclose) {
            buffer.append("[");
        }
        int current = 1;
        ListIterator c = this.constraints.listIterator();
        while (c.hasNext()) {
            Constraint constraint = (Constraint)c.next();
            buffer.append(constraint.toString());
            if (current < size) {
                buffer.append(" " + OP.toString() + " ");
            }
            ++current;
        }
        if (enclose) {
            buffer.append("]");
        }
        buffer.append(".");
        throw new XDSParameterException(buffer.toString(), this);
    }

    private Object applyTypeConstraints(String someValue) {
        Object typedValue;
        if (this.type == DataType.STRING || this.type == DataType.ANY) {
            typedValue = someValue;
        } else if (this.type == DataType.CHAR) {
            typedValue = CharConstraint.CHAR.parse(someValue);
        } else if (this.type == DataType.INT) {
            typedValue = IntConstraint.INT.parse(someValue);
        } else if (this.type == DataType.LONG) {
            typedValue = LongConstraint.LONG.parse(someValue);
        } else if (this.type == DataType.BOOLEAN) {
            typedValue = BooleanConstraint.BOOLEAN.parse(this, someValue);
        } else {
            throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
        }
        return typedValue;
    }

    public Character toCharacter() {
        try {
            return (Character)this.value;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.CHAR.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Integer toInteger() {
        try {
            return (Integer)this.value;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.INT.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Long toLong() {
        try {
            return (Long)this.value;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.LONG.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Boolean toBoolean() {
        try {
            return (Boolean)this.value;
        }
        catch (ClassCastException cc) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.BOOLEAN.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }

    boolean isRequired() {
        return this.required;
    }

    public int compareTo(Object someParam) {
        Lib.CheckParam(someParam, "someParam");
        Parameter param = (Parameter)someParam;
        String otherTag = param.tagName();
        if (this.tagName.compareTo(otherTag) < 0) {
            return -1;
        }
        if (this.tagName.compareTo(otherTag) > 0) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

