/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.CharComparator;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.EqualityOp;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LongComparator;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;

public class RangeConstraint
extends Constraint {
    public static final RangeConstraint POSITIVE;
    public static final RangeConstraint NON_NEGATIVE;
    public static final RangeConstraint NEGATIVE;
    private static final Comparator COMP_CHAR;
    private static final Comparator COMP_LONG;
    private static final String RANGE_SYMBOL;
    private static final boolean DEFAULT_NOT;
    private static final boolean DEFAULT_EMPTY;
    private Comparator comparator;
    private boolean same;
    private String first;
    private String last;
    private boolean empty;
    private EqualityOp op;

    private void init() {
        this.not = DEFAULT_NOT;
        this.empty = DEFAULT_EMPTY;
    }

    public RangeConstraint(char first, char last) {
        this.init();
        this.same = first == last;
        this.op = EqualityOp.NONE;
        this.comparator = COMP_CHAR;
        this.first = String.valueOf(first);
        this.last = String.valueOf(last);
    }

    public RangeConstraint(long first, long last) {
        this.init();
        this.same = first == last;
        this.op = EqualityOp.NONE;
        this.comparator = COMP_LONG;
        this.first = String.valueOf(first);
        this.last = String.valueOf(last);
    }

    private void setEmpty() {
        this.empty = true;
    }

    public RangeConstraint(long someNumber, EqualityOp someOp) {
        Lib.CheckParam(someOp, "someOp");
        this.init();
        if (someNumber == Long.MIN_VALUE && someOp == EqualityOp.LT || someNumber == Long.MAX_VALUE && someOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.op = someOp;
        this.first = String.valueOf(someNumber);
        this.comparator = COMP_LONG;
        this.last = null;
    }

    boolean isValid(Parameter param, String someValue) {
        if (someValue == null) {
            return true;
        }
        return this.empty ? false : this.compare(someValue);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private boolean compare(String someValue) {
        boolean returnVal;
        int result = this.comparator.compare(someValue, this.first);
        if (this.op == EqualityOp.NONE) {
            returnVal = result != -1 && this.comparator.compare(someValue, this.last) != 1;
        } else {
            switch (result) {
                case -1: {
                    returnVal = EqualityOp.IsLessThan(this.op);
                    break;
                }
                case 1: {
                    returnVal = EqualityOp.IsGreaterThan(this.op);
                    break;
                }
                case 0: {
                    returnVal = EqualityOp.MayBeEqual(this.op);
                    break;
                }
                default: {
                    throw new RuntimeException("Broken SWITCH statement.");
                }
            }
        }
        return this.not ? !returnVal : returnVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getLegalValues() {
        StringBuffer buffer = new StringBuffer(32);
        if (this.empty) {
            return "";
        }
        if (this.op == EqualityOp.NONE) {
            if (this.same) {
                if (this.comparator == COMP_CHAR) {
                    buffer.append("'" + this.first + "'");
                    return buffer.toString();
                } else {
                    if (this.comparator != COMP_LONG) throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
                    buffer.append(this.first);
                }
                return buffer.toString();
            } else if (this.comparator == COMP_CHAR) {
                buffer.append("'" + this.first + "' ");
                buffer.append(RANGE_SYMBOL);
                buffer.append("'" + this.last + "'");
                return buffer.toString();
            } else {
                if (this.comparator != COMP_LONG) throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
                buffer.append(this.first);
                buffer.append(RANGE_SYMBOL);
                buffer.append(this.last);
            }
            return buffer.toString();
        } else if (this.op == EqualityOp.GTE) {
            buffer.append(this.first + RANGE_SYMBOL + "n");
            return buffer.toString();
        } else if (this.op == EqualityOp.LTE) {
            buffer.append("n" + RANGE_SYMBOL + this.first);
            return buffer.toString();
        } else if (this.op == EqualityOp.GT) {
            buffer.append(String.valueOf(Long.parseLong(this.first) + 1L));
            buffer.append(RANGE_SYMBOL + "n");
            return buffer.toString();
        } else {
            if (this.op != EqualityOp.LT) return buffer.toString();
            buffer.append("n" + RANGE_SYMBOL);
            buffer.append(String.valueOf(Long.parseLong(this.first) - 1L));
        }
        return buffer.toString();
    }

    static {
        DEFAULT_EMPTY = false;
        DEFAULT_NOT = false;
        RANGE_SYMBOL = "...";
        COMP_CHAR = new CharComparator();
        COMP_LONG = new LongComparator();
        RangeConstraint temp = new RangeConstraint(0L, EqualityOp.GT);
        temp.setConstant();
        POSITIVE = temp;
        temp = new RangeConstraint(0L, EqualityOp.LT);
        temp.setConstant();
        NEGATIVE = temp;
        temp = new RangeConstraint(0L, EqualityOp.GTE);
        temp.setConstant();
        NON_NEGATIVE = temp;
    }
}

