/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSAddElement
extends ElementImpl
implements CommandElement,
AssociationElementParent,
PasswordElementParent {
    private String className;
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSPasswordElement password;
    private int noOfPasswords;
    private List addAttrs;

    private void init() {
        this.association = null;
        this.className = null;
        this.password = null;
        this.noOfPasswords = 0;
        this.noOfAssociations = 0;
        this.addAttrs = Collections.EMPTY_LIST;
    }

    XDSAddElement(Element addElement, DocumentImpl myDocument) throws XDSParseException {
        super(addElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1) {
                Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            }
            if (this.className == null) {
                this.throwMissingAttributeException("class-name");
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password != null && this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSPasswordElement extractPasswordElement() {
        return Lib.PasswordElementParent_passwordElement(this, this.password);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getTemplateDN() {
        return Lib.GetAttributeValue(this, "template-dn");
    }

    public List extractAddAttrElements() {
        return Lib.GetElements(this, this.addAttrs);
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    private void setPassword(XDSPasswordElement somePassword) {
        if (this.password == null) {
            this.password = somePassword;
        }
        ++this.noOfPasswords;
    }

    private List addAttrs(int noOfElements) {
        if (this.addAttrs == Collections.EMPTY_LIST) {
            this.addAttrs = new ArrayList(noOfElements);
        }
        return this.addAttrs;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("add-attr".compareTo(tagName) == 0) {
            child = new XDSAddAttrElement(childElement, this.document);
            this.addAttrs(noOfElements).add(child);
        } else if (this.document.context == 0) {
            if ("password".compareTo(tagName) == 0) {
                child = new XDSPasswordElement(childElement, this.document);
                this.setPassword((XDSPasswordElement)child);
            } else if ("association".compareTo(tagName) == 0 && "pending".equals(childElement.getAttribute("state"))) {
                child = XDS.IGNORE;
            }
        } else if (this.document.context == 1) {
            if ("password".compareTo(tagName) == 0) {
                child = new XDSPasswordElement(childElement, this.document);
                this.setPassword((XDSPasswordElement)child);
            } else if ("association".compareTo(tagName) == 0) {
                child = new XDSAssociationElement(childElement, this.document);
                this.setAssociation((XDSAssociationElement)child);
            }
        } else {
            throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
        }
        return child;
    }

    XDSAddElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "add");
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public void setTemplateDN(String someDN) {
        this.attributeValueSet("template-dn", someDN);
    }

    public XDSAddAttrElement appendAddAttrElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSAddAttrElement(this.document, this.element);
    }

    public XDSPasswordElement appendPasswordElement(String someText) {
        Lib.CheckContext(this.document.context, 1);
        this.password = new XDSPasswordElement(this.document, this.element);
        this.password.appendText(someText);
        return this.password;
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

