/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAllowAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSAllowClassElement
extends ElementImpl {
    private String className;
    private List allowAttrs;

    private void init() {
        this.className = null;
        this.allowAttrs = Collections.EMPTY_LIST;
    }

    XDSAllowClassElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    private List allowAttrs(int noOfElements) {
        if (this.allowAttrs == Collections.EMPTY_LIST) {
            this.allowAttrs = new ArrayList(noOfElements);
        }
        return this.allowAttrs;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSAllowAttrElement child = null;
        if ("allow-attr".compareTo(tagName) == 0) {
            child = new XDSAllowAttrElement(childElement, this.document);
            this.allowAttrs(noOfElements).add(child);
        }
        return child;
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate && this.className == null) {
            this.throwMissingAttributeException("class-name");
        }
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public List extractAllowAttrElements() {
        return Lib.GetElements(this, this.allowAttrs);
    }

    public List childElements() {
        return super.childElements();
    }

    XDSAllowClassElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "allow-class");
    }
}

