/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.List;
import org.w3c.dom.Element;

public class XDSCheckObjectPasswordElement
extends ElementImpl
implements CommandElement,
AssociationElementParent,
PasswordElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSPasswordElement password;
    private int noOfPasswords;

    private void init() {
        this.association = null;
        this.password = null;
        this.noOfPasswords = 0;
        this.noOfAssociations = 0;
    }

    XDSCheckObjectPasswordElement(Element addElement, DocumentImpl myDocument) throws XDSParseException {
        super(addElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1) {
                Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password != null && this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    public String getSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSPasswordElement extractPasswordElement() {
        return Lib.PasswordElementParent_passwordElement(this, this.password);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    private void setPassword(XDSPasswordElement somePassword) {
        if (this.password == null) {
            this.password = somePassword;
        }
        ++this.noOfPasswords;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("password".compareTo(tagName) == 0) {
            child = new XDSPasswordElement(childElement, this.document);
            this.setPassword((XDSPasswordElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    XDSCheckObjectPasswordElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "check-object-password");
    }

    public XDSPasswordElement appendPasswordElement(String someText) {
        this.doNotCall(1);
        return null;
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        this.doNotCall(1);
        return null;
    }

    public void setEventID(String someID) {
        this.doNotCall(1);
    }
}

