/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.StateDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSCommandDocument
extends DocumentImpl
implements ReadableDocument,
WriteableDocument,
StatusDocument,
StateDocument {
    private XDSInitParamsElement[] initParams;
    private XDSQueryElement identity;

    private void readInit() {
        this.initParams = null;
        this.commandContainer = true;
        this.identity = null;
    }

    private void writeInit() {
        this.initParams = new XDSInitParamsElement[1];
        this.initParams[0] = null;
        this.identity = null;
    }

    public XDSCommandDocument(XmlDocument xdsXML) throws XDSParseException {
        super(xdsXML, "input", 0, DocumentImpl.DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if (this.context == 0) {
            if ("add".compareTo(tagName) == 0) {
                child = new XDSAddElement(childElement, this);
            } else if ("modify".compareTo(tagName) == 0) {
                child = new XDSModifyElement(childElement, this);
            } else if ("delete".compareTo(tagName) == 0) {
                child = new XDSDeleteElement(childElement, this);
            } else if ("query".compareTo(tagName) == 0) {
                XDSQueryElement query = new XDSQueryElement(childElement, this);
                child = query;
                if (this.identity == null && query.isIdentity()) {
                    this.identity = query;
                }
            } else if ("move".compareTo(tagName) == 0) {
                child = new XDSMoveElement(childElement, this);
            } else if ("rename".compareTo(tagName) == 0) {
                child = new XDSRenameElement(childElement, this);
            }
            if (child == null && this.GTE(DTDVersion.V1_1) && "modify-password".compareTo(tagName) == 0) {
                child = new XDSModifyPasswordElement(childElement, this);
            }
            if (child == null && this.GTE(DTDVersion.V2_0) && "check-object-password".compareTo(tagName) == 0) {
                child = new XDSCheckObjectPasswordElement(childElement, this);
            }
        } else {
            if ("add".compareTo(tagName) == 0) {
                child = new XDSAddElement(childElement, this);
            } else if ("delete".compareTo(tagName) == 0) {
                child = new XDSDeleteElement(childElement, this);
            } else if ("modify".compareTo(tagName) == 0) {
                child = new XDSModifyElement(childElement, this);
            } else if ("move".compareTo(tagName) == 0) {
                child = new XDSMoveElement(childElement, this);
            } else if ("rename".compareTo(tagName) == 0) {
                child = new XDSRenameElement(childElement, this);
            } else if ("status".compareTo(tagName) == 0) {
                child = new XDSStatusElement(childElement, this);
            } else if ("init-params".compareTo(tagName) == 0) {
                child = new XDSInitParamsElement(childElement, this);
            } else if ("remove-association".compareTo(tagName) == 0) {
                child = new XDSRemoveAssociationElement(childElement, this);
            } else if ("modify-association".compareTo(tagName) == 0) {
                child = new XDSModifyAssociationElement(childElement, this);
            }
            if (child == null && this.GTE(DTDVersion.V1_1) && "modify-password".compareTo(tagName) == 0) {
                child = new XDSModifyPasswordElement(childElement, this);
            }
        }
        return child;
    }

    public XDSCommandDocument() {
        super("input", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSCommandDocument(DTDVersion dtdVersion) {
        super("input", 1, NDSVersion.CURRENT, dtdVersion);
        this.writeInit();
    }

    public XDSAddElement appendAddElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSAddElement(this, this.ioElement);
    }

    public XDSModifyElement appendModifyElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSModifyElement(this, this.ioElement);
    }

    public XDSRenameElement appendRenameElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSRenameElement(this, this.ioElement);
    }

    public XDSDeleteElement appendDeleteElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSDeleteElement(this, this.ioElement);
    }

    public XDSMoveElement appendMoveElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSMoveElement(this, this.ioElement);
    }

    private XDSCommandDocument(Document domDocument, ValidationLevel someLevel) throws XDSParseException {
        super(domDocument, "input", 1, someLevel);
        this.readInit();
        this.parseChildNodes();
    }

    public void validate() throws XDSParseException {
        new XDSCommandDocument(this.document, ValidationLevel.STRICT);
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public XDSModifyAssociationElement appendModifyAssociationElement() {
        return Lib.WriteableDocument_appendModifyAssociationElement(this);
    }

    public XDSModifyPasswordElement appendModifyPasswordElement() {
        Lib.CheckContext(this.context, 1);
        Lib.CheckVersion(this.version, DTDVersion.V1_1);
        return new XDSModifyPasswordElement(this, this.ioElement);
    }

    public XDSStatusElement heartBeatAppend() {
        Lib.CheckContext(this.context, 1);
        Lib.CheckVersion(this.version, DTDVersion.V1_1);
        return Lib.StatusDocument_appendHeartbeat(this);
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public XDSStatusElement appendStatusElement() {
        Lib.CheckContext(this.context, 1);
        return new XDSStatusElement(this, this.ioElement);
    }

    public XDSInitParamsElement appendInitParamsElement() {
        return Lib.StateDocument_appendInitParamsElement(this, this.initParams);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }

    public boolean containsIdentityQuery() {
        return this.identity != null;
    }

    public XDSQueryElement identityQuery() {
        return this.identity;
    }
}

