/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSDeleteElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;

    private void init() {
        this.association = null;
        this.noOfAssociations = 0;
    }

    XDSDeleteElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
        }
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSAssociationElement child = null;
        if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation(child);
        }
        return child;
    }

    XDSDeleteElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "delete");
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

