/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSInstanceElement
extends ElementImpl
implements AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private String className;
    private XDSParentElement parent;
    private int noOfParents;
    private List attrs;

    private void init() {
        this.association = null;
        this.className = null;
        this.parent = null;
        this.noOfAssociations = 0;
        this.noOfParents = 0;
        this.attrs = Collections.EMPTY_LIST;
    }

    XDSInstanceElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.className == null) {
                this.throwMissingAttributeException("class-name");
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, this.document.context == 1);
            if (this.document.validate && this.noOfParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("parent"));
            }
            if (this.document.isStrict()) {
                int position;
                int n = position = this.association == null ? 1 : 2;
                if (this.parent != null && this.parent.position() > position) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "parent", position));
                }
            }
        }
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String getSrcDN() {
        return Lib.GetAttributeValue(this, "src-dn");
    }

    public String getQualifiedSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-src-dn");
    }

    public String getEventID() {
        Lib.CheckContext(this.document.context, 0);
        return this.attributeValueGet("event-id");
    }

    public XDSParentElement extractParentElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.parent;
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractAttrElements() {
        return Lib.GetElements(this, this.attrs);
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setParent(XDSParentElement someParent) {
        if (this.parent == null) {
            this.parent = someParent;
        }
        ++this.noOfParents;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    private List attrs(int noOfElements) {
        if (this.attrs == Collections.EMPTY_LIST) {
            this.attrs = new ArrayList(noOfElements);
        }
        return this.attrs;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("attr".compareTo(tagName) == 0) {
            child = new XDSAttrElement(childElement, this.document);
            this.attrs(noOfElements).add(child);
        } else if ("parent".compareTo(tagName) == 0) {
            child = new XDSParentElement(childElement, this.document);
            this.setParent((XDSParentElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            if (this.document.context == 0) {
                if ("pending".equals(childElement.getAttribute("state"))) {
                    child = XDS.IGNORE;
                } else {
                    child = new XDSAssociationElement(childElement, this.document);
                    this.setAssociation((XDSAssociationElement)child);
                }
            } else if (this.document.context == 1) {
                child = new XDSAssociationElement(childElement, this.document);
                this.setAssociation((XDSAssociationElement)child);
            } else {
                throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
            }
        }
        return child;
    }

    XDSInstanceElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "instance");
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setEventID(String someID) {
        this.attributeValueSet("event-id", someID);
    }

    public XDSAttrElement appendAttrElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSAttrElement(this.document, this.element);
    }

    public XDSParentElement appendParentElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSParentElement(this.document, this.element);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

