/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementsParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyAssociationElement
extends ElementImpl
implements AssociationElementsParent,
CommandElement {
    private static final int NO_OF_ASSOCIATIONS = 2;
    private int noOfAssociations;
    private List associations;

    private void init() {
        this.associations = Collections.EMPTY_LIST;
        this.noOfAssociations = 0;
    }

    XDSModifyAssociationElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfAssociations < 2) {
                throw new XDSParseException(Errors.NoElement("association"));
            }
            if (this.noOfAssociations > 2) {
                throw new XDSParseException(Errors.TooManyElement(this.element.getTagName(), "association"));
            }
        }
    }

    private List associations(int noOfElements) {
        if (this.associations == Collections.EMPTY_LIST) {
            this.associations = new ArrayList(noOfElements);
        }
        return this.associations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSAssociationElement child = null;
        if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.associations(noOfElements).add(child);
            ++this.noOfAssociations;
        }
        return child;
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractAssociationElements() {
        return Lib.GetElements(this, this.associations);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcDN() {
        return null;
    }

    public String getQualifiedSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    XDSModifyAssociationElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "modify-association");
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        Lib.CheckContext(this.document.context, 1);
        XDSAssociationElement association = new XDSAssociationElement(this.document, this.element);
        association.appendText(someText);
        return association;
    }
}

