/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.SomeAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyAttrElement
extends ElementImpl
implements SomeAttrElement {
    private String attrName;

    private void init() {
        this.attrName = null;
    }

    XDSModifyAttrElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.attrName == null) {
                this.throwMissingAttributeException("attr-name");
            }
            if (this.children() == Collections.EMPTY_LIST) {
                throw new XDSParseException(Errors.NoChildElements("modify-attr"));
            }
        }
    }

    public String getAttrName() {
        return Lib.SomeAttrElement_getAttrName(this, this.attrName);
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("remove-value".compareTo(tagName) == 0) {
            child = new XDSRemoveValueElement(childElement, this.document);
        } else if ("remove-all-values".compareTo(tagName) == 0) {
            child = new XDSRemoveAllValuesElement(childElement, this.document);
        } else if ("add-value".compareTo(tagName) == 0) {
            child = new XDSAddValueElement(childElement, this.document);
        }
        return child;
    }

    XDSModifyAttrElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "modify-attr");
    }

    public void setAttrName(String someName) {
        Lib.SomeAttrElement_setAttrName(this, someName);
    }

    public XDSAddValueElement appendAddValueElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSAddValueElement(this.document, this.element);
    }

    public XDSRemoveValueElement appendRemoveValueElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSRemoveValueElement(this.document, this.element);
    }

    public XDSRemoveAllValuesElement appendRemoveAllValuesElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSRemoveAllValuesElement(this.document, this.element);
    }
}

