/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private List modifyAttrs;
    private int noOfAssociations;
    private String className;

    private void init() {
        this.association = null;
        this.className = null;
        this.noOfAssociations = 0;
        this.modifyAttrs = Collections.EMPTY_LIST;
    }

    XDSModifyElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1 && this.className == null) {
                throw new XDSParseException(Errors.NoAttributeValue("class-name"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.children() == Collections.EMPTY_LIST) {
                throw new XDSParseException(Errors.NoElement("modify-attr"));
            }
        }
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractModifyAttrElements() {
        return Lib.GetElements(this, this.modifyAttrs);
    }

    private List modifyAttrs(int noOfElements) {
        if (this.modifyAttrs == Collections.EMPTY_LIST) {
            this.modifyAttrs = new ArrayList(noOfElements);
        }
        return this.modifyAttrs;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("modify-attr".equals(tagName)) {
            child = new XDSModifyAttrElement(childElement, this.document);
            this.modifyAttrs(noOfElements).add(child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    XDSModifyElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "modify");
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public XDSModifyAttrElement appendModifyAttrElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSModifyAttrElement(this.document, this.element);
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

