/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.List;
import org.w3c.dom.Element;

public class XDSMoveElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSParentElement parentElement;
    private int noOfParents;

    private void init() {
        this.association = null;
        this.noOfAssociations = 0;
        this.parentElement = null;
        this.noOfParents = 0;
    }

    XDSMoveElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.parentElement == null) {
                throw new XDSParseException(Errors.NoElement("parent"));
            }
            if (this.noOfParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("parent"));
            }
        }
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getQualifiedOldSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-old-src-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getOldSrcDN() {
        return Lib.GetAttributeValue(this, "old-src-dn");
    }

    public XDSParentElement extractParentElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.parentElement;
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setParent(XDSParentElement someParent) {
        if (this.parentElement == null) {
            this.parentElement = someParent;
        }
        ++this.noOfParents;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("parent".compareTo(tagName) == 0) {
            child = new XDSParentElement(childElement, this.document);
            this.setParent((XDSParentElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    public List childElements() {
        return this.childElements();
    }

    XDSMoveElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "move");
    }

    public XDSParentElement appendParentElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSParentElement(this.document, this.element);
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setSrcDN(String someDN) {
        this.attributeValueSet("src-dn", someDN);
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public void setOldSrcDN(String someDN) {
        this.attributeValueSet("old-src-dn", someDN);
    }

    public XDSAssociationElement appendAssociationElement(String someText) {
        return Lib.AssociationElementParent_appendAssociationElement(this, someText);
    }
}

