/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.QueryScope;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSReadParentElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchClassElement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class XDSQueryElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private XDSAssociationElement association;
    private QueryScope scope;
    private XDSReadParentElement readParent;
    private boolean readAttributes;
    private List searchClasses;
    private List searchAttrs;
    private List readAttrs;
    private boolean identity;
    private int noOfReadParents;
    private String scopeString;
    private int noOfAssociations;
    private boolean ambiguousReadAttr;

    private void init() {
        this.association = null;
        this.readAttributes = true;
        this.searchClasses = Collections.EMPTY_LIST;
        this.searchAttrs = Collections.EMPTY_LIST;
        this.readAttrs = Collections.EMPTY_LIST;
        this.readParent = null;
        this.noOfAssociations = 0;
        this.noOfReadParents = 0;
        this.scope = null;
        this.scopeString = null;
        this.ambiguousReadAttr = false;
    }

    XDSQueryElement(Element query, DocumentImpl myDocument) throws XDSParseException {
        super(query, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.ambiguousReadAttr) {
                throw new XDSParseException(Errors.DuplicateElement("read-attr"));
            }
            if (this.noOfReadParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("read-parent"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, false);
            if (this.scope == null) {
                if (this.scopeString == null) {
                    this.throwMissingAttributeException("scope");
                } else {
                    throw new XDSParseException(Errors.BadAttributeValue("scope", this.scopeString));
                }
            }
        }
    }

    public String getSrcDN() {
        return null;
    }

    public String getQualifiedSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    public QueryScope getScope() {
        Lib.CheckContext(this.document.context, 0);
        return this.scope;
    }

    public boolean isIdentity() {
        Lib.CheckContext(this.document.context, 0);
        return this.identity;
    }

    public boolean hasEntryScope() {
        Lib.CheckContext(this.document.context, 0);
        return this.scope == QueryScope.ENTRY;
    }

    public boolean hasSubordinatesScope() {
        Lib.CheckContext(this.document.context, 0);
        return this.scope == QueryScope.SUBORDINATES;
    }

    public boolean hasSubtreeScope() {
        Lib.CheckContext(this.document.context, 0);
        return this.scope == QueryScope.SUBTREE;
    }

    private void parseAttributes() throws XDSParseException {
        this.scopeString = this.attributeValueGet("scope");
        this.scope = QueryScope.Lookup(this.scopeString);
        this.identity = "query-driver-ident".equals(this.attributeValueGet("event-id"));
    }

    private List searchClasses(int noOfElements) {
        if (this.searchClasses == Collections.EMPTY_LIST) {
            this.searchClasses = new LinkedList();
        }
        return this.searchClasses;
    }

    private List searchAttrs(int noOfElements) {
        if (this.searchAttrs == Collections.EMPTY_LIST) {
            this.searchAttrs = new LinkedList();
        }
        return this.searchAttrs;
    }

    private List readAttrs(int noOfElements) {
        if (this.readAttrs == Collections.EMPTY_LIST) {
            this.readAttrs = new LinkedList();
        }
        return this.readAttrs;
    }

    private void setReadParent(XDSReadParentElement someParent) {
        if (this.readParent == null) {
            this.readParent = someParent;
        }
        ++this.noOfReadParents;
    }

    private void setAssociation(XDSAssociationElement someAssociation) {
        if (this.association == null) {
            this.association = someAssociation;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("search-class".equals(tagName)) {
            child = new XDSSearchClassElement(childElement, this.document);
            XDSSearchClassElement searchClass = child;
            if ("__driver_identification_class__".equals(searchClass._getClassName())) {
                this.identity = true;
            }
            this.searchClasses(noOfElements).add(searchClass);
        } else if ("search-attr".equals(tagName)) {
            child = new XDSSearchAttrElement(childElement, this.document);
            this.searchAttrs(noOfElements).add(child);
        } else if ("read-attr".equals(tagName)) {
            child = new XDSReadAttrElement(childElement, this.document);
            XDSReadAttrElement readAttr = (XDSReadAttrElement)child;
            if (this.readAttributes) {
                if (readAttr._isNameless()) {
                    if (this.readAttrs == Collections.EMPTY_LIST) {
                        this.readAttributes = false;
                    } else {
                        this.ambiguousReadAttr = true;
                    }
                } else {
                    this.readAttrs(noOfElements).add(readAttr);
                }
            } else {
                if (!readAttr._isNameless()) {
                    this.ambiguousReadAttr = true;
                }
                this.readAttrs(noOfElements).add(readAttr);
            }
        } else if ("read-parent".compareTo(tagName) == 0) {
            child = new XDSReadParentElement(childElement, this.document);
            this.setReadParent((XDSReadParentElement)child);
        } else if ("association".compareTo(tagName) == 0) {
            child = new XDSAssociationElement(childElement, this.document);
            this.setAssociation((XDSAssociationElement)child);
        }
        return child;
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public boolean shouldSearchAllClasses() {
        return this.searchClasses == Collections.EMPTY_LIST;
    }

    public boolean shouldReadAttributes() {
        Lib.CheckContext(this.document.context, 0);
        return this.readAttributes;
    }

    public boolean hasRootBaseObject() {
        Lib.CheckContext(this.document.context, 0);
        return this.association == null && this.attributeValueGet("dest-dn") == null;
    }

    public boolean containsSearchAttrElements() {
        Lib.CheckContext(this.document.context, 0);
        return this.searchAttrs != Collections.EMPTY_LIST;
    }

    public boolean containsReadAttrElements() {
        Lib.CheckContext(this.document.context, 0);
        return this.readAttrs != Collections.EMPTY_LIST;
    }

    public boolean containsSearchClassElements() {
        Lib.CheckContext(this.document.context, 0);
        return this.searchClasses != Collections.EMPTY_LIST;
    }

    public List extractSearchClassElements() {
        return Lib.GetElements(this, this.searchClasses);
    }

    public List extractSearchAttrElements() {
        return Lib.GetElements(this, this.searchAttrs);
    }

    public List extractReadAttrElements() {
        return Lib.GetElements(this, this.readAttrs);
    }

    public boolean shouldReadParent() {
        Lib.CheckContext(this.document.context, 0);
        return this.readParent != null;
    }

    public XDSReadParentElement extractReadParentElement() {
        Lib.CheckContext(this.document.context, 0);
        return this.readParent;
    }

    XDSQueryElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "query");
    }

    public void setDestDN(String someDN) {
        this.attributeValueSet("dest-dn", someDN);
    }

    public void setClassName(String someName) {
        this.attributeValueSet("class-name", someName);
    }

    public void setEventID(String someID) {
        Lib.CommandElement_setEventID(this, someID);
    }

    public void setDestEntryID(String someID) {
        this.attributeValueSet("dest-entry-id", someID);
    }

    public void setScope(QueryScope someScope) {
        Lib.CheckContext(this.document.context, 1);
        if (someScope != null) {
            this.element.setAttribute("scope", someScope.toString());
        }
    }

    public XDSAssociationElement appendAssociationElement(String value) {
        return Lib.AssociationElementParent_appendAssociationElement(this, value);
    }

    public XDSSearchClassElement appendSearchClassElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSSearchClassElement(this.document, this.element);
    }

    public XDSSearchAttrElement appendSearchAttrElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSSearchAttrElement(this.document, this.element);
    }

    public XDSReadAttrElement appendReadAttrElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSReadAttrElement(this.document, this.element);
    }

    public XDSReadParentElement appendReadParentElement() {
        Lib.CheckContext(this.document.context, 1);
        if (this.readParent == null) {
            this.readParent = new XDSReadParentElement(this.document, this.element);
        }
        return this.readParent;
    }
}

