/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ReadAttrType;
import com.novell.nds.dirxml.driver.xds.SomeAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSReadAttrElement
extends ElementImpl
implements SomeAttrElement {
    private String attrName;
    private ReadAttrType type;
    private String typeString;

    private void init() {
        this.attrName = null;
        this.type = null;
        this.typeString = null;
    }

    XDSReadAttrElement(Element readAttr, DocumentImpl myDocument) throws XDSParseException {
        super(readAttr, myDocument);
        this.init();
        this.parseAttributes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.type == null) {
            if (this.typeString == null) {
                this.throwMissingAttributeException("type");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("type", this.typeString));
            }
        }
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
        this.typeString = this.attributeValueGet("type");
        this.type = ReadAttrType.Lookup(this.typeString);
    }

    public String getAttrName() {
        return Lib.SomeAttrElement_getAttrName(this, this.attrName);
    }

    public boolean isNameless() {
        Lib.CheckContext(this.document.context, 0);
        return this.attrName == null;
    }

    boolean _isNameless() {
        return this.attrName == null;
    }

    public ReadAttrType getType() {
        Lib.CheckContext(this.document.context, 0);
        if (this.type == null) {
            return ReadAttrType.DEFAULT;
        }
        return this.type;
    }

    public boolean hasXMLType() {
        Lib.CheckContext(this.document.context, 0);
        return this.type == ReadAttrType.XML;
    }

    public boolean hasDefaultType() {
        Lib.CheckContext(this.document.context, 0);
        return this.type == ReadAttrType.DEFAULT;
    }

    XDSReadAttrElement(DocumentImpl myDocument, Element parentElement) {
        super(myDocument, parentElement, "read-attr");
    }

    public void setAttrName(String someName) {
        Lib.SomeAttrElement_setAttrName(this, someName);
    }

    public void setType(ReadAttrType someType) {
        this.setAttributeValue("type", someType);
    }
}

