/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DNFormat;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import org.w3c.dom.Element;

public class XDSSchemaDefElement
extends ElementImpl {
    private static final _Boolean DEFAULT_HIERARCHICAL = _Boolean.FALSE;
    private _Boolean hierarchical;

    private void init() {
        this.hierarchical = DEFAULT_HIERARCHICAL;
    }

    XDSSchemaDefElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.hierarchical.equals(_Boolean.ILLEGAL)) {
            throw new XDSParseException(Errors.BadBooleanType(this.hierarchical.toString()));
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.hierarchical = Lib.ToBoolean(this.attributeValueGet("hierarchical"), DEFAULT_HIERARCHICAL);
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSClassDefElement child = null;
        if ("class-def".compareTo(tagName) == 0) {
            child = new XDSClassDefElement(childElement, this.document);
        }
        return child;
    }

    String getApplicationName() {
        Lib.CheckContext(this.document.context, 0);
        return this.attributeValueGet("application-name");
    }

    boolean getHierarchical() {
        Lib.CheckContext(this.document.context, 0);
        return this.hierarchical.toPrimitive();
    }

    XDSSchemaDefElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "schema-def");
    }

    public void setApplicationName(String someName) {
        this.attributeValueSet("application-name", someName);
    }

    public void setHierarchical(boolean isHierarchical) {
        this.attributeValueSet("hierarchical", DTD.GetStringValue(isHierarchical));
    }

    public void setDNFormat(DNFormat someFormat) {
        this.setAttributeValue("dn-format", someFormat, DTDVersion.V2_0);
    }

    public void setDNDelims(String someDelims) {
        this.setAttributeValue("dn-delims", someDelims, DTDVersion.V2_0);
    }

    public XDSClassDefElement appendClassDefElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSClassDefElement(this.document, this.element);
    }
}

