/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSContactElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import org.w3c.dom.Element;

public class XDSSourceElement
extends ElementImpl {
    private XDSProductElement product;
    private int noOfProducts;
    private XDSContactElement contact;
    private int noOfContacts;
    private String version;

    private void init() {
        this.product = null;
        this.noOfProducts = 0;
        this.contact = null;
        this.noOfContacts = 0;
        this.version = null;
    }

    XDSSourceElement(Element myElement, DocumentImpl myDocument) throws XDSParseException {
        super(myElement, myDocument);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfProducts > 1) {
                throw new XDSParseException(Errors.DuplicateElement("product"));
            }
            if (this.noOfContacts > 1) {
                throw new XDSParseException(Errors.DuplicateElement("contact"));
            }
        }
    }

    private void setProduct(XDSProductElement someProduct) {
        if (this.product == null) {
            this.product = someProduct;
        }
        ++this.noOfProducts;
    }

    private void setContact(XDSContactElement someContact) {
        if (this.contact == null) {
            this.contact = someContact;
        }
        ++this.noOfContacts;
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        ElementImpl child = null;
        if ("product".compareTo(tagName) == 0) {
            child = new XDSProductElement(childElement, this.document);
            this.setProduct((XDSProductElement)child);
        } else if ("contact".compareTo(tagName) == 0) {
            child = new XDSContactElement(childElement, this.document);
            this.setContact((XDSContactElement)child);
        }
        return child;
    }

    public XDSProductElement extractProductElement() {
        return this.product;
    }

    public String extractProductText() {
        return Lib.GetText(this, this.product);
    }

    public XDSContactElement extractContactElement() {
        return this.contact;
    }

    public String extractContactText() {
        return Lib.GetText(this, this.contact);
    }

    XDSSourceElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "source");
    }

    public XDSProductElement appendProductElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSProductElement(this.document, this.element);
    }

    public XDSContactElement appendContactElement(String someText) {
        Lib.CheckContext(this.document.context, 1);
        this.contact = new XDSContactElement(this.document, this.element);
        this.contact.appendText(someText);
        return this.contact;
    }
}

