/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DescriptionElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.ExceptionElement;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDSStatusElement
extends ElementImpl
implements TextParent,
Comparable {
    private static final String TAG_DOCUMENT = "document";
    private static final String COMMENT_SUPPRESSED = "content suppressed";
    private String level;
    private StatusLevel statusLevel;
    private StatusType statusType;
    private DescriptionElement description;
    private String text;

    private void init() {
        this.level = null;
        this.statusLevel = null;
        this.statusType = null;
        this.description = null;
        this.text = "";
        this.anyContent = true;
    }

    XDSStatusElement(Element statusElement, DocumentImpl myDocument) throws XDSParseException {
        super(statusElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    protected void passText(String someText) throws XDSParseException {
        this.text = this.text + someText;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.statusLevel == null) {
            if (this.level == null) {
                this.throwMissingAttributeException("level");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("level", this.level));
            }
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.level = this.attributeValueGet("level");
        this.statusLevel = StatusLevel.Lookup(this.level);
        this.statusType = StatusType.Lookup(this.attributeValueGet("type"));
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        DescriptionElement child = null;
        if ("description".compareTo(tagName) == 0) {
            this.description = child = new DescriptionElement(childElement, this.document);
        }
        return child;
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public StatusType getType() {
        Lib.CheckContext(this.document.context, 0);
        return this.statusType;
    }

    public StatusLevel getLevel() {
        Lib.CheckContext(this.document.context, 0);
        return this.statusLevel;
    }

    public String getEventID() {
        return Lib.GetAttributeValue(this, "event-id");
    }

    public DescriptionElement descriptionElementExtract() {
        Lib.CheckContext(this.document.context, 0);
        return this.description;
    }

    public String descriptionTextExtract() {
        return Lib.GetText(this, this.description);
    }

    XDSStatusElement(DocumentImpl myDocument, Element myParentElement) {
        super(myDocument, myParentElement, "status");
    }

    public void setLevel(StatusLevel someLevel) {
        if (someLevel != null) {
            this.element.setAttribute("level", someLevel.toString());
        }
    }

    public void setType(StatusType someType) {
        this.setAttributeValue("type", someType, DTDVersion.V1_1);
    }

    public void setEventID(String someID) {
        this.attributeValueSet("event-id", someID);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }

    public void parametersAppend(Map params) {
        Lib.CheckParam(params, "params");
        Collection parameters = params.values();
        if (parameters.size() > 0) {
            ArrayList sorted = new ArrayList(parameters.size());
            sorted.addAll(parameters);
            Collections.sort(sorted);
            Document domDoc = this.domDocument();
            Element parent = domDoc.createElement("parameters");
            this.element.appendChild(parent);
            ListIterator p = sorted.listIterator();
            while (p.hasNext()) {
                Parameter param = (Parameter)p.next();
                Element child = domDoc.createElement(param.tagName());
                String description = param.getDescription();
                if (description != null) {
                    child.setAttribute("display-name", description);
                }
                CharacterData content = param.isContentSensitive() ? domDoc.createComment("content suppressed!") : domDoc.createTextNode(param.toString());
                child.appendChild(content);
                parent.appendChild(child);
            }
        }
    }

    public void descriptionAppend(String someText) {
        Lib.CheckContext(this.document.context, 1);
        if (Lib.IsValue(someText)) {
            DescriptionElement temp = new DescriptionElement(this.document, this.element);
            temp.appendText(someText);
        }
    }

    public void documentAppend(XmlDocument xml) {
        if (xml != null) {
            Element docElement = this.document.document.createElement(TAG_DOCUMENT);
            this.element.appendChild(docElement);
            xml = XDSStatusElement.SuppressContent(xml);
            Node copy = Lib.CloneSubtree(this.document.document, xml.getDocument().getDocumentElement());
            docElement.appendChild(copy);
        }
    }

    private static XmlDocument SuppressContent(XmlDocument xml) {
        Node parent;
        Node oldChild;
        Document doc = xml.getDocument();
        NodeList nodes = doc.getElementsByTagName("password");
        Element newChild = doc.createElement("password");
        Comment comment = doc.createComment(COMMENT_SUPPRESSED);
        newChild.appendChild(comment);
        int n = 0;
        while (n < nodes.getLength()) {
            oldChild = nodes.item(n);
            parent = oldChild.getParentNode();
            if (parent != null) {
                parent.replaceChild(newChild, oldChild);
            }
            ++n;
        }
        nodes = doc.getElementsByTagName("old-password");
        newChild = doc.createElement("old-password");
        comment = doc.createComment(COMMENT_SUPPRESSED);
        newChild.appendChild(comment);
        int n2 = 0;
        while (n2 < nodes.getLength()) {
            oldChild = nodes.item(n2);
            parent = oldChild.getParentNode();
            if (parent != null) {
                parent.replaceChild(newChild, oldChild);
            }
            ++n2;
        }
        return new XmlDocument(doc);
    }

    public void exceptionAppend(Exception e, boolean stack) {
        if (e != null) {
            ExceptionElement temp = new ExceptionElement(this.document, this.element);
            temp.attributeValueSet("class-name", e.getClass().getName());
            temp.messageAppend(e);
            if (stack) {
                temp.stackTraceAppend(e);
            }
        }
    }

    public int compareTo(Object someStatus) {
        if (someStatus == null) {
            return -1;
        }
        if (this.statusLevel == null) {
            return 1;
        }
        return this.statusLevel.compareTo(((XDSStatusElement)someStatus).getLevel());
    }
}

