/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDSComponentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.util.Base64Codec;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XDSValueElement
extends ElementImpl
implements TextParent {
    private String typeString;
    private ValueType valueType;
    private String text;
    private String associationRef;
    private int noOfComponents;

    private void init() {
        this.text = "";
        this.associationRef = null;
        this.typeString = null;
        this.valueType = null;
        this.noOfComponents = 0;
    }

    protected void passText(String someText) throws XDSParseException {
        this.text = this.text + someText;
    }

    XDSValueElement(Element valueElement, DocumentImpl myDocument) throws XDSParseException {
        super(valueElement, myDocument);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validate() throws XDSParseException {
        if (!this.document.validate) return;
        if (this.valueType == null) {
            if (this.typeString != null) throw new XDSParseException(Errors.UnsupportedType(this.typeString));
            this.throwMissingAttributeException("type");
            return;
        } else {
            if (this.valueType == ValueType.DN) {
                if (this.associationRef != null || this.text != null) return;
                throw new XDSParseException(Errors.NoText("value"));
            }
            if (this.valueType == ValueType.STRUCTURED) {
                if (this.noOfComponents >= 1) return;
                throw new XDSParseException(Errors.NoElement("component"));
            }
            if (this.noOfComponents > 0) {
                throw new XDSParseException(Errors.ReqTypeStructured());
            }
            if (this.associationRef == null) return;
            throw new XDSParseException(Errors.ReqTypeDN());
        }
    }

    private void parseAttributes() {
        this.typeString = this.attributeValueGet("type");
        this.valueType = ValueType.Lookup(this.typeString);
        this.associationRef = this.attributeValueGet("association-ref");
    }

    public String getAssociationRef() {
        return Lib.GetValue((ElementImpl)this, this.associationRef);
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public byte[] bytes() throws IOException {
        Lib.CheckContext(this.document.context, 0);
        if (this.valueType != ValueType.OCTET || this.text == null) {
            return null;
        }
        return Base64Codec.decode((String)this.text);
    }

    public ValueType getType() {
        Lib.CheckContext(this.document.context, 0);
        return this.valueType;
    }

    public List extractComponentElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element childElement, String tagName, int position, int noOfElements) throws XDSParseException {
        XDSComponentElement child = null;
        if ("component".compareTo(tagName) == 0) {
            child = new XDSComponentElement(childElement, this.document);
            ++this.noOfComponents;
        }
        return child;
    }

    boolean isEmpty() {
        return this.children() == Collections.EMPTY_LIST && this.text == "";
    }

    XDSValueElement(DocumentImpl myDocument, Element myParentElement, ValueType myType) {
        super(myDocument, myParentElement, "value");
        if (myType != null) {
            this.valueType = myType;
            this.element.setAttribute("type", myType.toString());
        }
    }

    public void setType(ValueType someType) {
        this.setAttributeValue("type", someType);
    }

    public void appendText(String someText) {
        Lib.TextParent_appendText(this, someText);
    }

    public void appendBytes(byte[] bytes, int offset, int length) {
        Lib.CheckContext(this.document.context, 1);
        if (bytes == null) {
            return;
        }
        this.appendBase64EncodedText(Base64Codec.encode((byte[])bytes, (int)offset, (int)length));
    }

    public void appendBytes(byte[] bytes) {
        Lib.CheckContext(this.document.context, 1);
        if (bytes == null) {
            return;
        }
        this.appendBase64EncodedText(Base64Codec.encode((byte[])bytes));
    }

    private void appendBase64EncodedText(char[] encodedData) {
        Text textNode = this.document.document.createTextNode(String.valueOf(encodedData));
        this.element.appendChild(textNode);
    }

    public XDSComponentElement appendComponentElement() {
        Lib.CheckContext(this.document.context, 1);
        return new XDSComponentElement(this.document, this.element);
    }

    public void setAssociationRef(String someRef) {
        this.attributeValueSet("association-ref", someRef);
    }
}

