/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.Lib;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XDSUtil {
    private XDSUtil() {
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes);
        t.printStackTrace(writer);
        writer.flush();
        writer.close();
        return bytes.toString();
    }

    public static long toMillis(int seconds) {
        return seconds * 1000;
    }

    public static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, String description) {
        XDSStatusElement status = doc.appendStatusElement();
        if (attrs != null) {
            status.setLevel(attrs.getLevel());
            status.setType(attrs.getType());
            status.setEventID(attrs.getEventID());
        }
        status.descriptionAppend(description);
        return status;
    }

    private static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, XDSParameterException p, XmlDocument xml) {
        XDSStatusElement status = null;
        XDSParameterException next = p;
        while (next != null) {
            status = XDSUtil.appendStatus(doc, attrs, next.getMessage());
            next = next.getNext();
        }
        if (status != null && xml != null) {
            status.documentAppend(xml);
        }
        return status;
    }

    private static String getDescription(String description, Exception exception) {
        if (description == null) {
            if (exception == null) {
                return null;
            }
            return exception.toString();
        }
        return description;
    }

    public static XDSStatusElement appendStatus(StatusDocument doc, StatusAttributes attrs, String description, Exception exception, boolean stack, XmlDocument xml) {
        XDSStatusElement status = null;
        if (doc != null) {
            if (exception instanceof XDSParameterException) {
                status = XDSUtil.appendStatus(doc, attrs, (XDSParameterException)exception, xml);
            } else {
                status = doc.appendStatusElement();
                if (attrs != null) {
                    status.setLevel(attrs.getLevel());
                    status.setType(attrs.getType());
                    status.setEventID(attrs.getEventID());
                }
                status.descriptionAppend(XDSUtil.getDescription(description, exception));
                status.exceptionAppend(exception, stack);
                status.documentAppend(xml);
            }
        }
        return status;
    }

    public static void appendXML(Element element, String xml) {
        if (XDSUtil.isValue(xml) && element != null) {
            Node copy;
            Document doc = element.getOwnerDocument();
            XmlDocument tempXML = new XmlDocument(xml);
            Document tempDOM = tempXML.getDocument();
            if (tempDOM != null && (copy = Lib.cloneSubtree(doc, tempDOM.getDocumentElement())) != null) {
                element.appendChild(copy);
            }
        }
    }

    public static boolean appendStackTrace(Exception e) {
        return e instanceof RuntimeException;
    }

    public static boolean isValue(String someValue) {
        return someValue != null && "".compareTo(someValue) != 0;
    }

    public static boolean noValue(String someValue) {
        return someValue == null || "".compareTo(someValue) == 0;
    }

    private static String toNull(String someValue) {
        if (XDSUtil.noValue(someValue)) {
            return null;
        }
        return someValue;
    }

    public static String getChildText(Element someElement) {
        someElement.normalize();
        NodeList childNodes = someElement.getChildNodes();
        int n = 0;
        while (n < childNodes.getLength()) {
            short nodeType = childNodes.item(n).getNodeType();
            if (nodeType == 3) {
                Text textNode = (Text)childNodes.item(n);
                return XDSUtil.toNull(textNode.getData());
            }
            ++n;
        }
        return null;
    }
}

