/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Lib;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttrContainer;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.ValueElementsParent;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class CommonImpl
implements Constants {
    public static final String PRODUCT_NAME = "VRTest DirXML Driver";
    public static final String COMPANY_NAME = "Novell, Inc.";
    public static final String VERSION = "1.1";
    protected static final String TRACE_ID = "VRTest Driver";
    protected static final String DEFAULT_COUNT = "0";
    protected static final int COUNT_INCREMENT = 1;
    protected static final String TAG_TIME_STAMP = "time-stamp";
    protected static final String TAG_RUN_COUNT = "run-count";
    protected Map driverParams = null;
    protected String driverRDN = null;
    protected Trace trace = null;
    private long runCount = -1L;
    protected VRTestAPIWrapper api;
    protected boolean connected = false;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance();

    protected CommonImpl() {
    }

    protected void setDriverParams(Map params) {
        this.driverParams = params;
    }

    Map getDriverParams() {
        return this.driverParams;
    }

    protected void setDriverRDN(String name) {
        this.driverRDN = name;
    }

    protected String getDriverRDN() {
        return this.driverRDN == null ? TRACE_ID : this.driverRDN;
    }

    protected void setTrace(String suffix) {
        String header = suffix == null ? this.getDriverRDN() : this.getDriverRDN() + "\\" + suffix;
        this.trace = new Trace(header);
    }

    protected void setRunCount(long nonNegative) {
        this.runCount = nonNegative + 1L;
    }

    protected long getRunCount() {
        return this.runCount;
    }

    protected void setAPI(VRTestAPIWrapper someAPI) {
        Lib.CheckParam(someAPI, "someAPI");
        this.api = someAPI;
    }

    protected VRTestAPIWrapper getAPI() {
        return this.api;
    }

    protected void appendSourceInfo(WriteableDocument doc) {
        if (doc != null) {
            XDSSourceElement source = doc.appendSourceElement();
            XDSProductElement product = source.appendProductElement();
            product.setBuild("20030127_0314");
            product.setInstance(this.driverRDN);
            product.setVersion(VERSION);
            product.appendText(PRODUCT_NAME);
            source.appendContactElement(COMPANY_NAME);
        }
    }

    protected XDSResultDocument newResultDoc() {
        XDSResultDocument resultDoc = new XDSResultDocument();
        this.appendSourceInfo((WriteableDocument)resultDoc);
        return resultDoc;
    }

    protected XDSCommandDocument newCommandDoc() {
        XDSCommandDocument commandDoc = new XDSCommandDocument();
        this.appendSourceInfo((WriteableDocument)commandDoc);
        return commandDoc;
    }

    protected void connect() throws IOException, VRTestException {
        this.trace.trace("connect", 1);
        if (!this.connected) {
            Object object = this.api.connectMutex;
            synchronized (object) {
                if (this.api.badConnection()) {
                    if (this.api.connected()) {
                        this.api.resetConnection();
                    } else {
                        this.api.openConnection();
                    }
                }
            }
        }
    }

    protected void disconnect() {
        this.trace.trace("disconnect", 1);
        this.connected = false;
        if (this.api != null) {
            Object object = this.api.connectMutex;
            synchronized (object) {
                this.api.closeConnection();
            }
        }
    }

    protected String getConnectHeader() {
        if (this.connected) {
            return "Lost connection.";
        }
        return "Unable to connect.";
    }

    protected void queryHandler(XDSQueryElement query, QueryResultDocument result) throws VRTestException, IOException {
        this.trace.trace("queryHandler", 1);
        if (query == null) {
            return;
        }
        VRTestObject baseObject = this.getBaseObject(query, result);
        if (baseObject == null) {
            return;
        }
        VRTestAttributeFilter readAttributes = this.getReadAttributeFilter(query);
        if (query.hasEntryScope()) {
            if (this.api.isRootObject(baseObject)) {
                return;
            }
            this.appendInstanceElement(result, baseObject, readAttributes);
        } else {
            List searchClassNames = this.getSearchClasses(query);
            VRTestAttributeFilter searchAttributes = this.getSearchAttributeFilter(query);
            if (this.api.getSchema().isHierarchical()) {
                if (query.hasSubordinatesScope()) {
                    this.subordinateObjectsToXDS(result, baseObject, searchClassNames, searchAttributes, readAttributes);
                } else {
                    this.subtreeObjectsToXDS(result, baseObject, searchClassNames, searchAttributes, readAttributes);
                }
            } else {
                this.objectsToXDS(result, searchClassNames, searchAttributes, readAttributes);
            }
        }
    }

    private VRTestObject getBaseObject(XDSQueryElement query, QueryResultDocument result) throws VRTestException, IOException {
        String association = query.extractAssociationText();
        if (association != null) {
            VRTestObject baseObject = this.api.getObjectByAssociation(association, null);
            return baseObject;
        }
        String dn = query.getDestDN();
        if (dn != null) {
            return this.api.getObjectByDN(dn);
        }
        return this.api.getRootObject();
    }

    private VRTestAttributeFilter getReadAttributeFilter(XDSQueryElement query) throws VRTestException {
        VRTestAttributeFilter readFilter;
        if (query.shouldReadAttributes()) {
            if (query.containsReadAttrElements()) {
                readFilter = new VRTestAttributeFilter();
                ListIterator readAttrs = query.extractReadAttrElements().listIterator();
                while (readAttrs.hasNext()) {
                    XDSReadAttrElement readAttr = (XDSReadAttrElement)readAttrs.next();
                    String attrName = readAttr.getAttrName();
                    readFilter.addAttribute(attrName);
                }
            } else {
                readFilter = VRTestAttributeFilter.ALL_ATTRIBUTES;
            }
        } else {
            readFilter = VRTestAttributeFilter.NO_ATTRIBUTES;
        }
        return readFilter;
    }

    private List getSearchClasses(XDSQueryElement query) {
        if (query.containsSearchClassElements()) {
            return query.extractSearchClassElements();
        }
        return this.api.getSchema().getClassSchemas();
    }

    private VRTestAttributeFilter getSearchAttributeFilter(XDSQueryElement query) throws VRTestException {
        VRTestAttributeFilter searchFilter;
        if (query.containsSearchAttrElements()) {
            List searchAttrs = query.extractSearchAttrElements();
            ListIterator l = searchAttrs.listIterator();
            searchFilter = new VRTestAttributeFilter();
            while (l.hasNext()) {
                XDSSearchAttrElement searchAttr = (XDSSearchAttrElement)l.next();
                String attrName = searchAttr.getAttrName();
                CommonImpl.ToVRTestAttributes(searchFilter, (ValueElementsParent)searchAttr, attrName);
            }
        } else {
            searchFilter = VRTestAttributeFilter.NO_ATTRIBUTES;
        }
        return searchFilter;
    }

    private void objectsToXDS(QueryResultDocument result, List searchClasses, VRTestAttributeFilter searchAttributes, VRTestAttributeFilter readAttributes) throws VRTestException, IOException {
        ListIterator sc = searchClasses.listIterator();
        while (sc.hasNext()) {
            Object searchClass = sc.next();
            List objects = this.api.getMatchingObjects(searchClass.toString(), searchAttributes);
            ListIterator o = objects.listIterator();
            while (o.hasNext()) {
                VRTestObject object = (VRTestObject)o.next();
                this.appendInstanceElement(result, object, readAttributes);
            }
        }
    }

    private void subordinateObjectsToXDS(QueryResultDocument result, VRTestObject baseObject, List searchClasses, VRTestAttributeFilter searchAttributes, VRTestAttributeFilter readAttributes) throws VRTestException, IOException {
        ListIterator sc = searchClasses.listIterator();
        while (sc.hasNext()) {
            Object searchClass = sc.next();
            List objects = this.api.getMatchingObjects(searchClass.toString(), searchAttributes);
            ListIterator o = objects.listIterator();
            while (o.hasNext()) {
                VRTestObject object = (VRTestObject)o.next();
                if (!baseObject.isSubordinate(object)) continue;
                this.appendInstanceElement(result, object, readAttributes);
            }
        }
    }

    private void subtreeObjectsToXDS(QueryResultDocument result, VRTestObject baseObject, List searchClasses, VRTestAttributeFilter searchAttributes, VRTestAttributeFilter readAttributes) throws VRTestException, IOException {
        ListIterator sc = searchClasses.listIterator();
        while (sc.hasNext()) {
            Object searchClass = sc.next();
            List objects = this.api.getMatchingObjects(searchClass.toString(), searchAttributes);
            ListIterator o = objects.listIterator();
            while (o.hasNext()) {
                VRTestObject object = (VRTestObject)o.next();
                if (!baseObject.inSubtree(object)) continue;
                this.appendInstanceElement(result, object, readAttributes);
            }
        }
    }

    private void appendInstanceElement(QueryResultDocument result, VRTestObject object, VRTestAttributeFilter readAttributes) throws VRTestException, IOException {
        XDSInstanceElement instance = result.appendInstanceElement();
        instance.setClassName(object.getClassName());
        instance.setSrcDN(object.getDN());
        instance.appendAssociationElement(object.extractAssociationText());
        if (readAttributes != null) {
            this.appendAttrElements(instance, object.getAttributes(readAttributes));
        }
    }

    private void appendAttrElements(XDSInstanceElement instance, List attributes) {
        ListIterator a = attributes.listIterator();
        while (a.hasNext()) {
            VRTestAttribute attribute = (VRTestAttribute)a.next();
            XDSAttrElement attr = instance.appendAttrElement();
            attr.setAttrName(attribute.getName());
            attr.appendValueElement(attribute.getValue());
        }
    }

    protected static void ToVRTestAttributes(VRTestAddAttrContainer attributes, ValueElementsParent element, String attributeName) throws VRTestException {
        ListIterator v = element.extractValueElements().listIterator();
        while (v.hasNext()) {
            XDSValueElement value = (XDSValueElement)v.next();
            attributes.addAttribute(attributeName, value.extractText());
        }
    }

    void appendStateInfo(StateParent state) {
        Document doc = state.domDocument();
        Element parent = state.domElement();
        Element timeStamp = doc.createElement(TAG_TIME_STAMP);
        Text text = doc.createTextNode(this.dateFormat.format(new Date()));
        timeStamp.appendChild(text);
        parent.appendChild(timeStamp);
        Element runCount = doc.createElement(TAG_RUN_COUNT);
        text = doc.createTextNode(String.valueOf(this.runCount));
        runCount.appendChild(text);
        parent.appendChild(runCount);
    }
}

