/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifiedObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifyAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestNotification;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.vrtest.VRTestAPI;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestEvent;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class VRTestAPIWrapper
implements VRTestConstants {
    private int id;
    private int port;
    private String host;
    private boolean connected = false;
    private boolean bad = true;
    public final Object connectMutex;
    private boolean loopBack;
    private VRTestSchema schema;
    private VRTestAPI api;
    private VRTestRootObject root;
    private XmlQueryProcessor queryProcessor;
    private XDSCommandResultDocument associationDoc;

    VRTestAPIWrapper(String hostValue, int portValue) {
        this.host = hostValue;
        this.port = portValue;
        this.api = new VRTestAPI();
        this.root = new VRTestRootObject();
        this.loopBack = false;
        this.connectMutex = this.api.connectMutex;
        this.associationDoc = new XDSCommandResultDocument();
        XDSStatusElement status = this.associationDoc.appendStatusElement();
        status.setLevel(StatusLevel.WARNING);
        status.appendText("Object missing required association.");
    }

    boolean connected() {
        return this.connected;
    }

    boolean badConnection() {
        return this.bad;
    }

    void setQueryProcessor(XmlQueryProcessor aProcessor) throws VRTestException {
        this.queryProcessor = aProcessor;
    }

    public void setLoopBack(boolean allowLoopBack) {
        this.loopBack = allowLoopBack;
    }

    public VRTestObject createObject(String className, VRTestAddAttributes attributes) throws VRTestException, IOException {
        if (attributes == null) {
            throw new IllegalArgumentException(Errors.nullParam("className"));
        }
        long handle = this.api.create(className, attributes.getList());
        VRTestObject object = new VRTestObject(handle, null, className, this);
        if (object.extractAssociationText() == null) {
            throw new VRTestException("Object missing required association.");
        }
        return object;
    }

    public void deleteObject(String association, String className) throws VRTestException, IOException {
        VRTestObject object = this.getObjectByAssociation(association, className);
        if (object == null) {
            return;
        }
        this.api.deleteByHandle(object.getHandle());
    }

    public boolean isRootObject(VRTestObject object) {
        return this.root == object;
    }

    public VRTestRootObject getRootObject() {
        return this.root;
    }

    public List getMatchingObjects(String className, VRTestAttributeFilter filter) throws VRTestException, IOException {
        VRTestAttributeList attributes = filter == VRTestAttributeFilter.NO_ATTRIBUTES ? null : filter.getList();
        LinkedList<VRTestObject> objects = new LinkedList<VRTestObject>();
        try {
            Object object = this.api.findMutex;
            synchronized (object) {
                long handle = this.api.findFirst(className, attributes);
                while (handle != 0L) {
                    VRTestObject object2 = new VRTestObject(handle, null, className, this);
                    objects.add(object2);
                    handle = this.api.findNext();
                }
            }
            return objects;
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
    }

    public void modifyObject(VRTestObject object, VRTestModifyAttributes attributes) throws VRTestException, IOException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(Errors.nullParam("attributes"));
        }
        try {
            this.api.modifyByHandle(object.getHandle(), attributes.getList());
            object.resetAttributes();
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
    }

    public VRTestNotification waitForNotification(XmlCommandProcessor processor, Trace trace) throws VRTestException, IOException {
        if (processor == null) {
            throw new IllegalArgumentException(Errors.nullParam("processor"));
        }
        VRTestEvent event = null;
        VRTestModifiedObject object = null;
        try {
            while (event == null) {
                event = this.api.waitForEvent();
                if (this.isLoopBack(event.getID())) {
                    trace.trace("Loopback event.");
                    event = null;
                    continue;
                }
                object = new VRTestModifiedObject(event.getHandle(), null, event.getClassName(), event.getAttributes(), this);
                if (object.extractAssociationText() != null) continue;
                processor.execute(this.associationDoc.toXML(), this.queryProcessor);
                event = null;
            }
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
        return new VRTestNotification(event.getType(), object);
    }

    public VRTestSchema getSchema() {
        return this.schema;
    }

    public void openConnection() throws VRTestException, IOException {
        if (!this.connected) {
            this.api.startSession(this.host, this.port);
            this.id = this.api.getClientID();
            this.schema = this.api.getSchema();
            this.bad = false;
            this.connected = true;
        }
    }

    public void closeConnection() {
        this.connected = false;
        this.bad = true;
        this.api.endSession();
    }

    public void resetConnection() throws VRTestException, IOException {
        this.closeConnection();
        this.openConnection();
    }

    public VRTestObject getObjectByAssociation(String association, String className) throws VRTestException, IOException {
        if (association == null) {
            throw new IllegalArgumentException(Errors.nullParam("association"));
        }
        if (this.root.hasAssociation(association)) {
            return this.root;
        }
        VRTestAttributeFilter filter = new VRTestAttributeFilter();
        filter.addAttribute("Unique Id", association);
        try {
            return this.findObject(className, filter);
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
    }

    private VRTestObject findObject(String className, VRTestAttributeFilter filter) throws VRTestException, IOException {
        long handle = 0L;
        if (className != null) {
            Object object = this.api.findMutex;
            synchronized (object) {
                handle = this.api.findFirst(className, filter.getList());
            }
        }
        ListIterator c = this.schema.getClassSchemas().listIterator();
        while (c.hasNext()) {
            VRTestClassSchema classSchema = (VRTestClassSchema)c.next();
            Object object = this.api.findMutex;
            synchronized (object) {
                handle = this.api.findFirst(classSchema.toString(), filter.getList());
            }
            if (handle == 0L) continue;
            className = classSchema.toString();
            break;
        }
        if (handle == 0L) {
            return null;
        }
        return new VRTestObject(handle, null, className, this);
    }

    public VRTestObject getObjectByDN(String dn) throws VRTestException, IOException {
        if (this.root.hasDN(dn)) {
            return this.root;
        }
        VRTestDNParser parser = new VRTestDNParser(dn, VRTestDNType.VRTEST);
        try {
            return this.getObjectByNameANDPath(parser.getObjectName(), parser.getObjectPath());
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
    }

    VRTestObject getObjectByNameANDPath(String name, String path) throws VRTestException, IOException {
        if (name == null) {
            throw new IllegalArgumentException(Errors.nullParam("name"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Errors.nullParam("path"));
        }
        try {
            return this.findObject(name, path);
        }
        catch (IOException io) {
            this.bad = true;
            throw io;
        }
    }

    private VRTestObject findObject(String name, String path) throws VRTestException, IOException {
        ListIterator c = this.schema.getClassSchemas().listIterator();
        long handle = 0L;
        VRTestAttributeFilter filter = new VRTestAttributeFilter();
        VRTestClassSchema classSchema = null;
        String namingAttributeName = null;
        while (c.hasNext()) {
            classSchema = (VRTestClassSchema)c.next();
            VRTestAttributeSchema namingAttributeSchema = classSchema.getNamingAttributeSchema();
            namingAttributeName = namingAttributeSchema.getName();
            filter.addAttribute("Object Path", path);
            filter.addAttribute(namingAttributeName, name);
            Object object = this.api.findMutex;
            synchronized (object) {
                handle = this.api.findFirst(classSchema.getName(), filter.getList());
            }
            if (handle != 0L) break;
            filter.clear();
        }
        if (handle == 0L) {
            return null;
        }
        return new VRTestObject(handle, name, classSchema.getName(), this);
    }

    VRTestAttributeList getAttributes(long handle) throws VRTestException, IOException {
        return this.api.getAttributesByHandle(handle);
    }

    private boolean isLoopBack(long eventID) {
        return !this.loopBack && (long)this.id == eventID;
    }
}

