/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;

class VRTestDNParser
implements VRTestConstants,
Constants {
    private String name;
    private String path;

    VRTestDNParser(String dn, VRTestDNType type) throws VRTestException {
        this.parseObjectNameANDPath(dn, type);
    }

    private void parseObjectNameANDPath(String dn, VRTestDNType type) throws VRTestException {
        this.path = VRTestDNParser.ParseObjectPath(dn, type);
        this.name = dn.substring(this.path.length(), dn.length());
    }

    static String ParseObjectPath(String dn, VRTestDNType type) throws VRTestException {
        if (dn == null) {
            throw new IllegalArgumentException(Errors.nullParam("dn"));
        }
        if (type == null) {
            throw new IllegalArgumentException(Errors.nullParam("type"));
        }
        int beginIndex = type == VRTestDNType.VRTEST ? 0 : 1;
        int pathBeginIndex = dn.indexOf(92, beginIndex);
        int pathEndIndex = dn.lastIndexOf(92) + 1;
        if (pathBeginIndex == -1 || pathEndIndex == -1 || pathEndIndex < pathBeginIndex) {
            throw new VRTestException(Errors.badDN(dn));
        }
        return dn.substring(pathBeginIndex, pathEndIndex);
    }

    String getObjectName() {
        return this.name;
    }

    String getObjectPath() {
        return this.path;
    }
}

