/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.VRTestClassFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestFilterName;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class VRTestDriverFilter {
    Vector classFilters;

    /*
     * WARNING - void declaration
     */
    public VRTestDriverFilter(Element filterElement) {
        this.classFilters = new Vector();
        if (filterElement != null) {
            Element allowClass;
            int i = 0;
            NodeList list = filterElement.getElementsByTagName("allow-class");
            while ((allowClass = (Element)list.item(i++)) != null) {
                Element allowAttr;
                void var4_5;
                String className = var4_5.getAttribute("class-name");
                VRTestClassFilter classFilter = new VRTestClassFilter(className);
                this.classFilters.addElement(classFilter);
                NodeList attrList = var4_5.getElementsByTagName("allow-attr");
                int j = 0;
                while ((allowAttr = (Element)attrList.item(j++)) != null) {
                    void var9_9;
                    classFilter.addAttribute(var9_9.getAttribute("attr-name"));
                }
            }
        }
    }

    private VRTestDriverFilter() {
    }

    public boolean passClass(String className) {
        return this.getClassFilter(className) != null;
    }

    public VRTestClassFilter getClassFilter(String className) {
        Enumeration filters = this.classFilters.elements();
        while (filters.hasMoreElements()) {
            VRTestClassFilter filter = (VRTestClassFilter)filters.nextElement();
            if (!filter.hasClassName(className)) continue;
            return filter;
        }
        return null;
    }

    void setProperties(VRTestSchema schema) {
        Enumeration filters = this.classFilters.elements();
        while (filters.hasMoreElements()) {
            VRTestClassFilter filter = (VRTestClassFilter)filters.nextElement();
            VRTestFilterName className = filter.getClassName();
            VRTestClassSchema classSchema = schema.getClassSchema(className.toString());
            if (classSchema == null) continue;
            className.setCaseSensitive(classSchema.isCaseSensitive());
            Enumeration attributeNames = filter.enumAttributeNames();
            while (attributeNames.hasMoreElements()) {
                VRTestFilterName attributeName = (VRTestFilterName)attributeNames.nextElement();
                VRTestAttributeSchema attributeSchema = classSchema.getAttributeSchema(attributeName.toString());
                if (attributeSchema == null) continue;
                attributeName.setCaseSensitive(attributeSchema.isCaseSensitive());
            }
        }
    }
}

