/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestPublicationShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestSubscriptionShim;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverStateElement;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSchemaDefElement;
import com.novell.nds.dirxml.driver.xds.XDSSchemaResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ListIterator;

public class VRTestDriverShim
extends CommonImpl
implements DriverShim {
    private static final String TRACE_SUFFIX = "Driver";
    private static final int NO_OF_PARAMS = 2;
    private static final String TAG_PORT = "port";
    private static final String TAG_HOST = "host";
    private static final String DEFAULT_HOST = "localhost";
    private static final String APPLICATION_NAME = "VRTest";
    private VRTestSubscriptionShim subscriptionShim;
    private VRTestPublicationShim publicationShim;

    public VRTestDriverShim() {
        this.setDriverRDN("VRTest Driver");
        this.setTrace(null);
        this.setDriverParams();
        this.subscriptionShim = null;
        this.publicationShim = null;
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(2);
        Parameter param = new Parameter(TAG_PORT, null, DataType.INT);
        param.add((Constraint)RequiredConstraint.REQUIRED);
        param.add((Constraint)new RangeConstraint(1L, 65535L));
        this.driverParams.put(param.tagName(), param);
        param = new Parameter(TAG_HOST, DEFAULT_HOST, DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("run-count", "0", DataType.LONG);
        param.add((Constraint)RangeConstraint.POSITIVE);
        this.driverParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        this.trace.trace("init", 1);
        XDSResultDocument result = new XDSResultDocument();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            this.setDriverRDN(init.rdn());
            this.setTrace(TRACE_SUFFIX);
            this.appendSourceInfo((WriteableDocument)result);
            init.parameters(this.driverParams);
            this.setAPI(new VRTestAPIWrapper(this.driverParams.get(TAG_HOST).toString(), ((Parameter)this.driverParams.get(TAG_PORT)).toInteger()));
            Parameter param = (Parameter)this.driverParams.get("run-count");
            this.setRunCount(param.toLong());
            param.overrideValue(String.valueOf(this.getRunCount()));
            this.subscriptionShim = new VRTestSubscriptionShim(this);
            this.publicationShim = new VRTestPublicationShim(this);
            XDSDriverStateElement driverState = result.appendInitParamsElement().appendDriverStateElement();
            this.appendStateInfo((StateParent)driverState);
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement status = XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
            status.parametersAppend(this.driverParams);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
        }
        return result.toXML();
    }

    public XmlDocument shutdown(XmlDocument reasonXML) {
        this.trace.trace("shutdown", 1);
        XDSResultDocument result = this.newResultDoc();
        try {
            if (this.publicationShim != null) {
                this.publicationShim.shutdown();
            }
            if (this.subscriptionShim != null) {
                this.subscriptionShim.shutdown();
            }
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)true, null);
        }
        return result.toXML();
    }

    public SubscriptionShim getSubscriptionShim() {
        this.trace.trace("getSubscriptionShim", 1);
        return this.subscriptionShim;
    }

    public PublicationShim getPublicationShim() {
        this.trace.trace("getPublicationShim", 1);
        return this.publicationShim;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlDocument getSchema(XmlDocument initXML) {
        this.trace.trace("getSchema", 1);
        XDSSchemaResultDocument resultDoc = new XDSSchemaResultDocument();
        try {
            try {
                XDSInitDocument initDoc = new XDSInitDocument(initXML);
                this.setDriverRDN(initDoc.rdn());
                this.setTrace(TRACE_SUFFIX);
                this.appendSourceInfo((WriteableDocument)resultDoc);
                XDSDriverOptionsElement options = initDoc.extractInitParamsElement().extractDriverOptionsElement();
                options.parameters(this.driverParams);
                this.setAPI(new VRTestAPIWrapper(this.driverParams.get(TAG_HOST).toString(), ((Parameter)this.driverParams.get(TAG_PORT)).toInteger()));
                this.connect();
                VRTestSchema schema = this.api.getSchema();
                this.disconnect();
                VRTestDriverShim.appendSchemaDefElement(resultDoc, schema);
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, null);
                XDSUtil.appendStatus((StatusDocument)resultDoc, (StatusAttributes)attrs, null);
            }
            catch (Exception e) {
                resultDoc.empty();
                StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_STATUS, null);
                XDSUtil.appendStatus((StatusDocument)resultDoc, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
                Object var8_10 = null;
                this.disconnect();
                return resultDoc.toXML();
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.disconnect();
            throw throwable;
        }
        this.disconnect();
        return resultDoc.toXML();
    }

    private static void appendSchemaDefElement(XDSSchemaResultDocument resultDoc, VRTestSchema schema) {
        XDSSchemaDefElement schemaDef = resultDoc.appendSchemaDefElement();
        schemaDef.setApplicationName(APPLICATION_NAME);
        schemaDef.setHierarchical(schema.isHierarchical());
        VRTestDriverShim.appendClassDefElements(schemaDef, schema);
    }

    private static void appendClassDefElements(XDSSchemaDefElement schemaDef, VRTestSchema schema) {
        ListIterator cs = schema.getClassSchemas().listIterator();
        while (cs.hasNext()) {
            VRTestClassSchema classSchema = (VRTestClassSchema)cs.next();
            XDSClassDefElement classDef = schemaDef.appendClassDefElement();
            classDef.setClassName(classSchema.getName());
            classDef.setContainer(classSchema.isContainer());
            VRTestDriverShim.appendAttrDefElements(classDef, classSchema);
        }
    }

    private static void appendAttrDefElements(XDSClassDefElement classDef, VRTestClassSchema classSchema) {
        VRTestAttributeSchema namingAttrSchema = classSchema.getNamingAttributeSchema();
        Enumeration attrSchemas = classSchema.enumAttributeSchemas();
        while (attrSchemas.hasMoreElements()) {
            VRTestAttributeSchema attrSchema = (VRTestAttributeSchema)attrSchemas.nextElement();
            boolean isNamingAttr = attrSchema == namingAttrSchema;
            XDSAttrDefElement attrDef = classDef.appendAttrDefElement();
            attrDef.setAttrName(attrSchema.getName());
            attrDef.setCaseSensitive(attrSchema.isCaseSensitive());
            attrDef.setMultiValued(attrSchema.isMultiValued());
            attrDef.setNaming(isNamingAttr);
            attrDef.setReadOnly(attrSchema.isReadOnly());
            attrDef.setRequired(attrSchema.isRequired());
            attrDef.setType(ValueType.STRING);
        }
    }
}

