/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class VRTestModifiedObject
extends VRTestObject {
    private VRTestAttributeList modifiedAttributes;

    VRTestModifiedObject(long aHandle, String aName, String aClassName, VRTestAttributeList someAttributes, VRTestAPIWrapper anAPI) throws VRTestException, IOException {
        super(aHandle, aName, aClassName, anAPI);
        this.modifiedAttributes = someAttributes;
    }

    List getModifiedAttributes() {
        return this.modifiedAttributes.attributes();
    }

    boolean renamed(LinkedList newNames) throws VRTestException {
        LinkedList matches = this.modifiedAttributes.getAttribute(this.getNamingAttributeSchema());
        if (matches == null) {
            return false;
        }
        boolean removed = false;
        boolean multiValued = this.namingAttributeSchema.isMultiValued();
        ListIterator iterator = matches.listIterator();
        while (iterator.hasNext()) {
            VRTestAttribute namingAttribute = (VRTestAttribute)iterator.next();
            VRTestAction action = namingAttribute.getAction();
            if (action == VRTestAction.ADD) {
                if (!multiValued) {
                    removed = true;
                }
                newNames.add(namingAttribute.getValue());
                continue;
            }
            if (action != VRTestAction.REMOVE) continue;
            removed = true;
        }
        return removed;
    }

    void removeCurrent() {
        this.modifiedAttributes.removeCurrent();
    }

    VRTestAttribute getAttributeByName(String attributeName) throws VRTestException, IOException {
        VRTestAttribute attribute = this.modifiedAttributes.getAttributeByName(attributeName);
        if (attribute == null) {
            attribute = super.getAttributeByName(attributeName);
        }
        return attribute;
    }

    String getNewPath() {
        if (this.hierarchical) {
            VRTestAttribute pathAttribute = this.modifiedAttributes.getPath();
            if (pathAttribute == null) {
                return null;
            }
            this.modifiedAttributes.removeCurrent();
            return pathAttribute.getValue();
        }
        return null;
    }

    boolean hasMoreModifiedAttributes() {
        return !this.modifiedAttributes.isEmpty();
    }
}

