/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class VRTestObject
implements VRTestConstants,
Constants {
    private static final int DN_LENGTH = 20;
    private long handle;
    private VRTestAPIWrapper api;
    protected String association;
    protected String dn;
    protected String name;
    protected LinkedList otherNames;
    protected String className;
    protected String path;
    protected boolean hierarchical;
    protected VRTestClassSchema classSchema;
    protected VRTestAttributeList attributes;
    protected VRTestAttributeSchema namingAttributeSchema;

    protected VRTestObject(String aName, String aPath, String aDN, String anAssociation) {
        this.name = aName;
        this.path = aPath;
        this.dn = aDN;
        this.association = anAssociation;
        this.attributes = VRTestAttributeList.EMPTY;
        this.className = null;
        this.classSchema = null;
        this.handle = -1L;
        this.api = null;
        this.hierarchical = true;
        this.otherNames = null;
        this.namingAttributeSchema = null;
    }

    VRTestObject(long aHandle, String aName, String aClassName, VRTestAPIWrapper anAPI) throws VRTestException {
        this.api = anAPI;
        this.className = aClassName;
        this.handle = aHandle;
        this.name = aName;
        this.attributes = VRTestAttributeList.EMPTY;
        this.dn = null;
        this.association = null;
        this.path = null;
        this.classSchema = null;
        this.hierarchical = this.api.getSchema().isHierarchical();
        this.otherNames = null;
        this.namingAttributeSchema = null;
    }

    VRTestClassSchema getClassSchema() throws VRTestException {
        if (this.classSchema == null) {
            this.classSchema = this.api.getSchema().getClassSchema(this.className);
            if (this.classSchema == null) {
                throw new VRTestException(Errors.noClassSchema(this.className));
            }
        }
        return this.classSchema;
    }

    long getHandle() {
        return this.handle;
    }

    String getName() throws VRTestException, IOException {
        if (this.name == null) {
            this.setNames();
        }
        return this.name;
    }

    LinkedList getOtherNames() throws VRTestException, IOException {
        if (this.name == null) {
            this.setNames();
        }
        return this.otherNames;
    }

    List getAttributes() throws VRTestException, IOException {
        this.setAttributes();
        return this.attributes.attributes();
    }

    private void setAttributes() throws VRTestException, IOException {
        if (this.attributes == VRTestAttributeList.EMPTY) {
            this.attributes = this.api.getAttributes(this.handle);
        }
    }

    private void setNames() throws VRTestException, IOException {
        this.setAttributes();
        this.getNamingAttributeSchema();
        LinkedList namingAttribute = this.attributes.getAttribute(this.namingAttributeSchema);
        if (namingAttribute != null) {
            if (this.namingAttributeSchema.isMultiValued()) {
                this.name = ((VRTestAttribute)namingAttribute.getFirst()).getValue();
                namingAttribute.removeFirst();
                ListIterator iterator = namingAttribute.listIterator();
                while (iterator.hasNext()) {
                    if (this.otherNames == null) {
                        this.otherNames = new LinkedList();
                    }
                    this.otherNames.add(((VRTestAttribute)iterator.next()).getValue());
                }
            } else {
                this.name = ((VRTestAttribute)namingAttribute.getFirst()).getValue();
            }
        }
    }

    String extractAssociationText() throws VRTestException, IOException {
        VRTestAttribute attribute;
        if (this.association == null && (attribute = this.getAttributeByName("Unique Id")) != null) {
            this.association = attribute.getValue();
        }
        return this.association;
    }

    VRTestAttribute getAttributeByName(String attributeName) throws VRTestException, IOException {
        this.setAttributes();
        return this.attributes.getAttributeByName(attributeName);
    }

    String getClassName() {
        return this.className;
    }

    String getDN() throws VRTestException, IOException {
        if (this.dn == null) {
            this.setDN();
        }
        return this.dn;
    }

    private void setDN() throws VRTestException, IOException {
        StringBuffer dnBuffer = new StringBuffer(20);
        if (this.hierarchical) {
            this.getPath();
            if (this.path == null) {
                return;
            }
            dnBuffer.append(this.path);
        }
        this.getName();
        if (this.name == null) {
            return;
        }
        dnBuffer.append(this.name);
        this.dn = dnBuffer.toString();
    }

    String getPath() throws VRTestException, IOException {
        if (this.path == null && this.hierarchical) {
            this.setPath();
        }
        return this.path;
    }

    private void setPath() throws VRTestException, IOException {
        this.setAttributes();
        VRTestAttribute attribute = this.attributes.getPath();
        if (attribute != null) {
            this.path = attribute.getValue();
        }
    }

    List getAttributes(VRTestAttributeFilter filter) throws VRTestException, IOException {
        if (filter == VRTestAttributeFilter.NO_ATTRIBUTES) {
            return Collections.EMPTY_LIST;
        }
        this.setAttributes();
        if (filter == VRTestAttributeFilter.ALL_ATTRIBUTES) {
            return this.attributes.attributes();
        }
        this.getClassSchema();
        VRTestAttributeList filteredAttributes = new VRTestAttributeList();
        List filterAttributes = filter.attributes();
        VRTestAttribute filterAttribute = null;
        VRTestAttribute objectAttribute = null;
        ListIterator fa = filterAttributes.listIterator();
        while (fa.hasNext()) {
            LinkedList matches;
            filterAttribute = (VRTestAttribute)fa.next();
            VRTestAttributeSchema attributeSchema = this.classSchema.getAttributeSchema(filterAttribute.getName());
            if (attributeSchema == null || (matches = this.attributes.getAttribute(attributeSchema)) == null) continue;
            ListIterator ma = matches.listIterator();
            while (ma.hasNext()) {
                objectAttribute = (VRTestAttribute)ma.next();
                filteredAttributes.addAttribute(objectAttribute);
            }
        }
        return filteredAttributes.attributes();
    }

    VRTestAttributeSchema getNamingAttributeSchema() throws VRTestException {
        if (this.namingAttributeSchema == null) {
            this.namingAttributeSchema = this.getClassSchema().getNamingAttributeSchema();
        }
        return this.namingAttributeSchema;
    }

    void resetAttributes() {
        this.attributes = VRTestAttributeList.EMPTY;
    }

    boolean isSubordinate(VRTestObject object) throws VRTestException, IOException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (this == object) {
            return false;
        }
        String parentDN = this.getDN();
        String childDN = object.getDN();
        if (childDN == null || parentDN == null) {
            throw new VRTestException("Object missing required dn.");
        }
        int parentLength = parentDN.length();
        boolean prefixMatch = parentDN.regionMatches(true, 0, childDN, 0, parentLength);
        if (!prefixMatch) {
            return false;
        }
        int lastDelimIndex = childDN.lastIndexOf(92);
        return lastDelimIndex == parentLength - 1;
    }

    boolean inSubtree(VRTestObject object) throws VRTestException, IOException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (this == object) {
            return true;
        }
        String rootDN = this.getDN();
        String subDN = object.getDN();
        if (rootDN == null || subDN == null) {
            throw new VRTestException("Object missing required dn.");
        }
        if (subDN == null) {
            return false;
        }
        int rootLength = rootDN.length();
        boolean prefixMatch = rootDN.regionMatches(true, 0, subDN, 0, rootLength);
        if (!prefixMatch) {
            return false;
        }
        return subDN.charAt(rootLength - 1) == '\\';
    }
}

