/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;

class VRTestPathParser
implements VRTestConstants,
Constants {
    private String containerName;
    private String containerPath;
    private String containerDN;

    VRTestPathParser(String objectPath) throws VRTestException {
        if (objectPath == null) {
            throw new IllegalArgumentException(Errors.nullParam("objectPath"));
        }
        this.parsePath(objectPath);
    }

    String getContainerName() {
        return this.containerName;
    }

    String getContainerPath() {
        return this.containerPath;
    }

    String getContainerDN() {
        return this.containerDN;
    }

    private void parsePath(String objectPath) throws VRTestException {
        int endDelimIndex = objectPath.lastIndexOf(92);
        if (endDelimIndex == -1) {
            throw new VRTestException(Errors.badPath(objectPath));
        }
        if (endDelimIndex == 0) {
            this.containerName = VRTestRootObject.NAME;
            this.containerPath = VRTestRootObject.PATH;
            this.containerDN = "\\";
        } else {
            int beginDelimIndex = objectPath.lastIndexOf(92, endDelimIndex - 1);
            if (beginDelimIndex == -1) {
                throw new VRTestException(Errors.badPath(objectPath));
            }
            this.containerName = objectPath.substring(beginDelimIndex + 1, endDelimIndex);
            int dnBeginDelimIndex = objectPath.indexOf(92);
            this.containerDN = objectPath.substring(dnBeginDelimIndex, endDelimIndex);
            endDelimIndex = beginDelimIndex;
            beginDelimIndex = objectPath.indexOf(92);
            this.containerPath = objectPath.substring(beginDelimIndex, endDelimIndex + 1);
        }
    }
}

